/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.module.result;

import com.humuson.tms.config.Column;
import com.humuson.tms.controller.module.result.ResultHandler;
import com.humuson.tms.util.date.DateUtil;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@Qualifier(value="ResultBatchHandler")
public class ResultBatchHandler
extends ResultHandler {
    private static final Logger log = LoggerFactory.getLogger(ResultBatchHandler.class);

    public HashMap<String, HashMap<String, String>> makeTlistCrslt(HashMap<String, String> mapPINFO, ArrayList<HashMap<String, String>> totalItems) throws Exception {
        long tfailCount = Long.valueOf(String.valueOf(mapPINFO.get("FAILED_TARGET")));
        HashMap mapCrslt = new HashMap();
        HashMap<String, String> mapTlist = new HashMap<String, String>();
        String isCancled = String.valueOf(mapPINFO.get("UserCancleException"));
        for (HashMap<String, String> target : totalItems) {
            if (target.isEmpty()) continue;
            try {
                JSONObject jsonTarget = new JSONObject(target);
                JSONArray arrJsonTlist = new JSONArray();
                if (jsonTarget.has(Column.MULTI_TARGET_JSON_LIST) && !jsonTarget.isNull(Column.MULTI_TARGET_JSON_LIST)) {
                    arrJsonTlist = jsonTarget.getJSONArray(Column.MULTI_TARGET_JSON_LIST);
                    jsonTarget.remove(Column.MULTI_TARGET_JSON_LIST);
                }
                arrJsonTlist.put((Object)jsonTarget);
                for (int i = 0; i < arrJsonTlist.length(); ++i) {
                    jsonTarget = arrJsonTlist.getJSONObject(i);
                    jsonTarget.put(Column.MEMBER_ID, jsonTarget.get(Column.TMS_M_ID));
                    String redisTlistField = this.redisKeyMaker.TLISTField(mapPINFO, jsonTarget);
                    String redisCrsltField = this.redisKeyMaker.CRSLTField(mapPINFO, jsonTarget);
                    if (jsonTarget.has(Column.SEND_ID)) {
                        jsonTarget.remove(Column.SEND_ID);
                    }
                    if (jsonTarget.has(Column.SCHD_ID)) {
                        jsonTarget.remove(Column.SCHD_ID);
                    }
                    if (jsonTarget.has(Column.WORKDAY)) {
                        jsonTarget.remove(Column.WORKDAY);
                    }
                    if (jsonTarget.has(Column.TARGET_ID)) {
                        jsonTarget.remove(Column.TARGET_ID);
                    }
                    if (jsonTarget.has(Column.TARGET_SEQ)) {
                        jsonTarget.remove(Column.TARGET_SEQ);
                    }
                    if (jsonTarget.has(Column.CHANNEL_TYPE)) {
                        jsonTarget.remove(Column.CHANNEL_TYPE);
                    }
                    if (jsonTarget.has(Column.REG_ID)) {
                        jsonTarget.remove(Column.REG_ID);
                    }
                    if (jsonTarget.has("CT_MEMBER_ID")) {
                        jsonTarget.remove("CT_MEMBER_ID");
                    }
                    if (jsonTarget.has("CT_MEMBER_ID_SEQ")) {
                        jsonTarget.remove("CT_MEMBER_ID_SEQ");
                    }
                    if (jsonTarget.has("CT_MEMBER_NAME")) {
                        jsonTarget.remove("CT_MEMBER_NAME");
                    }
                    if (jsonTarget.has("CT_CODE_DETAIL")) {
                        jsonTarget.remove("CT_CODE_DETAIL");
                    }
                    if (jsonTarget.has("CT_EVENT_TIME")) {
                        jsonTarget.remove("CT_EVENT_TIME");
                    }
                    if (jsonTarget.has("CT_EVENT_TYPE")) {
                        jsonTarget.remove("CT_EVENT_TYPE");
                    }
                    if (jsonTarget.has("CT_CONTENT_DATA")) {
                        jsonTarget.remove("CT_CONTENT_DATA");
                    }
                    if (isCancled.trim().equalsIgnoreCase("Y")) {
                        jsonTarget.put(Column.STATUS, (Object)"CT601");
                    }
                    try {
                        mapTlist.put(redisTlistField, jsonTarget.toString());
                        continue;
                    }
                    catch (Exception e) {
                        log.debug("[makeTlistCrslt] tlist & crslt({}) putting map has an error. remove this data. and increase tfailCount ", jsonTarget.get(Column.TMS_M_ID));
                        ++tfailCount;
                        if (mapTlist.containsKey(redisTlistField)) {
                            mapTlist.remove(redisTlistField);
                        }
                        if (!mapCrslt.containsKey(redisCrsltField)) continue;
                        mapCrslt.remove(redisCrsltField);
                    }
                }
            }
            catch (Exception e) {
                log.debug("{} : makeTlistCrslt has an exception. this target change TFAIL user", (Object)this.getClass().getSimpleName());
                ++tfailCount;
            }
        }
        mapPINFO.put("FAILED_TARGET", tfailCount + "");
        mapPINFO.put("COUNT_TARGET", mapTlist.size() + "");
        HashMap<String, HashMap<String, String>> arrMergedList = new HashMap<String, HashMap<String, String>>();
        arrMergedList.put("PINFO", mapPINFO);
        arrMergedList.put("TLIST", mapTlist);
        arrMergedList.put("CRSLT", mapCrslt);
        return arrMergedList;
    }

    public JSONObject makeCRSLT(HashMap<String, String> mapPINFO, JSONObject originTarget) throws Exception {
        JSONObject jsonCrslt = new JSONObject();
        jsonCrslt.put(Column.START_TIME, (Object)DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
        jsonCrslt.put(Column.END_TIME, (Object)DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
        jsonCrslt.put(Column.RESULT_TYPE, (Object)"S");
        jsonCrslt.put(Column.SERVER_ID, (Object)("CT" + this.daemonId));
        jsonCrslt.put(Column.SITE_ID, (Object)String.valueOf(mapPINFO.get(Column.SITE_ID)));
        jsonCrslt.put(Column.SCHD_ID, (Object)String.valueOf(mapPINFO.get(Column.SCHD_ID)));
        jsonCrslt.put(Column.TARGET_SEQ, (Object)String.valueOf(mapPINFO.get(Column.TARGET_SEQ)));
        jsonCrslt.put(Column.WORKDAY, (Object)String.valueOf(mapPINFO.get(Column.WORKDAY)));
        jsonCrslt.put(Column.ERROR_DETAIL, (Object)"CT Filtering");
        if (originTarget.has(Column.LOG_DETAIL) && !originTarget.isNull(Column.LOG_DETAIL)) {
            jsonCrslt.put(Column.ERROR_DETAIL, (Object)("CT Filtering : " + originTarget.get(Column.LOG_DETAIL)));
        }
        jsonCrslt.put(Column.ERROR_CODE, originTarget.get(Column.STATUS));
        jsonCrslt.put(Column.MEMBER_ID, originTarget.get(Column.TMS_M_ID));
        jsonCrslt.put(Column.DOMAIN, originTarget.get(Column.DOMAIN));
        jsonCrslt.put(Column.UNIQUE_SEQ, originTarget.get(Column.UNIQUE_SEQ));
        return jsonCrslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashMap<String, String> redisSend(HashMap<String, String> mapPINFO, HashMap<String, HashMap<String, String>> arrTlistCrslt) throws Exception {
        long tfailCount = Long.valueOf(String.valueOf(mapPINFO.get("FAILED_TARGET")));
        long processCount = Long.valueOf(String.valueOf(mapPINFO.get("COUNT_TARGET")));
        String keyTLIST = String.valueOf(mapPINFO.get("KEY_TLIST"));
        String keyCRSLT = String.valueOf(mapPINFO.get("KEY_CRSLT"));
        boolean isTlistUploadFail = false;
        HashMap<Object, Object> mapTlist = new HashMap();
        try {
            if (arrTlistCrslt.containsKey("TLIST")) {
                mapTlist = arrTlistCrslt.get("TLIST");
            }
            if (mapTlist != null && mapTlist.size() > 0) {
                this.redisUtil.hmSetAll(keyTLIST, mapTlist);
                if (this.isResultLog) {
                    log.info("Redis::[TLIST].hmsetAll. DONE =====SEND_ID[{}], key : {}, size : {}", new Object[]{String.valueOf(mapPINFO.get(Column.SEND_ID)), keyTLIST, mapTlist.size()});
                }
            }
        }
        catch (Exception e) {
            log.error("{}|||Redis  ({ }) has an Exception. TLIST doesn't upload. and it turned TLIST count(+{}). e: {}", new Object[]{"CM0201", keyTLIST, mapTlist.size(), e});
            tfailCount += (long)mapTlist.size();
            processCount -= (long)mapTlist.size();
            isTlistUploadFail = true;
        }
        finally {
            mapTlist.clear();
        }
        HashMap<Object, Object> mapCrslt = new HashMap();
        try {
            if (!isTlistUploadFail) {
                if (arrTlistCrslt.containsKey("CRSLT")) {
                    mapCrslt = arrTlistCrslt.get("CRSLT");
                }
                if (mapCrslt != null && mapCrslt.size() > 0) {
                    this.redisUtil.hmSetAll(keyCRSLT, mapCrslt);
                    if (this.isResultLog) {
                        log.info("Redis::[CRSLT].hmsetAll. DONE =====SEND_ID[{}], key : {}, size : {}", new Object[]{String.valueOf(mapPINFO.get(Column.SEND_ID)), keyCRSLT, mapCrslt.size()});
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("{}|||Redis  ({ }) has an Exception. CRSLT doesn't upload. and it turned TFAIL count(+{}). e:{}", new Object[]{"CM0201", keyCRSLT, mapCrslt.size(), e});
            tfailCount += (long)mapCrslt.size();
            processCount -= (long)mapCrslt.size();
        }
        finally {
            mapCrslt.clear();
        }
        mapPINFO.put("FAILED_TARGET", tfailCount + "");
        mapPINFO.put("COUNT_TARGET", processCount + "");
        return mapPINFO;
    }
}

