/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.module;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.controller.module.TmsAdditionPINFO;
import com.humuson.tms.controller.repository.dao.SchedulerDao;
import com.humuson.tms.controller.repository.dao.TargeterDao;
import com.humuson.tms.controller.util.StringUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PINFOMaker {
    @Autowired
    protected StringUtil<Object> stringUtil;
    @Autowired
    protected SchedulerDao schedulerDao;
    @Autowired
    protected TargeterDao targeterDao;
    @Autowired
    protected TmsAdditionPINFO tmsAdditionPinfo;

    public HashMap<String, Object> get(long sendId, long schdId) {
        HashMap<String, Object> mapPINFO = this.selectJoinTables(sendId, schdId);
        if (this.stringUtil.hasKey(mapPINFO, Column.ERROR_CODE)) {
            return mapPINFO;
        }
        HashMap<String, Object> mapAdditionPInfo = this.tmsAdditionPinfo.execute(mapPINFO);
        if (mapAdditionPInfo != null && mapAdditionPInfo.size() > 0) {
            mapPINFO.putAll(mapAdditionPInfo);
        }
        return mapPINFO;
    }

    protected HashMap<String, Object> selectJoinTables(long sendId, long schdId) {
        String errorTable = "TMS_SEND_INFO or TMS_SCHD_INFO or TMS_SCHD_TARGET";
        HashMap<Object, Object> mapSchedule = new HashMap<String, Long>();
        try {
            mapSchedule = this.schedulerDao.selectDefaultInfo(schdId);
            if (mapSchedule == null || mapSchedule.size() == 0) {
                mapSchedule = new HashMap();
                mapSchedule.put(Column.SEND_ID, sendId);
                mapSchedule.put(Column.SCHD_ID, schdId);
                return this.joinTableError(mapSchedule, errorTable);
            }
            errorTable = "TMS_SITE_INFO or TMS_CAMP_INFO";
            HashMap<String, Object> mapInfo = this.schedulerDao.selectSiteInfo(Long.valueOf(String.valueOf(mapSchedule.get(Column.CAMP_ID)).trim()));
            if (mapInfo == null || mapInfo.size() == 0) {
                return this.joinTableError(mapSchedule, errorTable);
            }
            if (mapInfo.size() > 0) {
                mapSchedule.putAll(mapInfo);
            }
            errorTable = "TMS_CONTENT_INFO";
            mapInfo = this.schedulerDao.selectContentInfo(Long.valueOf(String.valueOf(mapSchedule.get(Column.CONTENT_ID)).trim()));
            if (mapInfo == null || mapInfo.size() == 0) {
                return this.joinTableError(mapSchedule, errorTable);
            }
            if (mapInfo.size() > 0) {
                mapSchedule.putAll(mapInfo);
            }
            errorTable = "TMS_CHANNEL_INFO";
            mapInfo = this.schedulerDao.selectChannelInfo(Long.valueOf(String.valueOf(mapSchedule.get(Column.CHANNEL_ID)).trim()));
            if (mapInfo == null || mapInfo.size() == 0) {
                return this.joinTableError(mapSchedule, errorTable);
            }
            if (mapInfo.size() > 0) {
                mapSchedule.putAll(mapInfo);
            }
            errorTable = "TMS_TARGET_INFO";
            if (!Constants.TriggerMethod.F1.name().equalsIgnoreCase(String.valueOf(mapSchedule.get(Column.TRIGGER_METHOD)).trim())) {
                mapInfo = this.schedulerDao.selectTargetInfo(Long.valueOf(String.valueOf(mapSchedule.get(Column.TARGET_ID)).trim()));
                if (mapInfo == null || mapInfo.size() == 0) {
                    return this.joinTableError(mapSchedule, errorTable);
                }
                if (mapInfo.size() > 0) {
                    mapSchedule.putAll(mapInfo);
                }
            }
            errorTable = "TMS_ADDITION_INFO";
            mapInfo = this.schedulerDao.selectAdditionInfo(Long.valueOf(String.valueOf(mapSchedule.get(Column.SEND_ADD_ID)).trim()));
            if (mapInfo == null || mapInfo.size() == 0) {
                return this.joinTableError(mapSchedule, errorTable);
            }
            if (mapInfo != null && mapInfo.size() > 0) {
                mapSchedule.putAll(mapInfo);
            }
            errorTable = "TMS_CONTROL_INFO";
            mapInfo = this.schedulerDao.selectControlInfo(Long.valueOf(String.valueOf(mapSchedule.get(Column.SEND_ADD_ID)).trim()));
            if (mapInfo == null || mapInfo.size() == 0) {
                return this.joinTableError(mapSchedule, errorTable);
            }
            if (mapInfo != null && mapInfo.size() > 0) {
                mapSchedule.putAll(mapInfo);
            }
            errorTable = "TMS_FATIGUE_INFO";
            if (this.stringUtil.hasKey(mapSchedule, Column.FATIGUE_YN) && this.stringUtil.isEqual(mapSchedule, Column.FATIGUE_YN, "Y")) {
                mapInfo = this.schedulerDao.selectFatigueInfo(Long.valueOf(String.valueOf(mapSchedule.get(Column.SITE_ID)).trim()), String.valueOf(mapSchedule.get(Column.CHANNEL_TYPE)).trim());
                if (mapInfo == null || mapInfo.size() == 0) {
                    return this.joinTableError(mapSchedule, errorTable);
                }
                if (mapInfo != null && mapInfo.size() > 0) {
                    mapSchedule.putAll(mapInfo);
                }
            }
            errorTable = "TMS_SECURE_MAIL_INFO";
            if (this.stringUtil.hasKey(mapSchedule, Column.SECURE_YN) && this.stringUtil.isEqual(mapSchedule, Column.SECURE_YN, "Y")) {
                mapInfo = this.schedulerDao.selectSecureMailInfo(Long.valueOf(String.valueOf(mapSchedule.get(Column.SEND_ADD_ID)).trim()));
                if (mapInfo == null || mapInfo.size() == 0) {
                    return this.joinTableError(mapSchedule, errorTable);
                }
                if (mapInfo != null && mapInfo.size() > 0) {
                    mapSchedule.putAll(mapInfo);
                }
            }
            errorTable = "TMS_APP_INFO";
            if (Constants.ChannelType.PU.name().equalsIgnoreCase(String.valueOf(mapSchedule.get(Column.CHANNEL_TYPE)).trim())) {
                List<HashMap<String, Object>> mapList = this.schedulerDao.selectAppInfo(Long.valueOf(String.valueOf(mapSchedule.get(Column.APP_GRP_ID)).trim()));
                if (mapList == null || mapList.size() == 0) {
                    return this.joinTableError(mapSchedule, errorTable);
                }
                if (mapList != null && mapList.size() > 0) {
                    mapSchedule.putAll((Map<Object, Object>)mapList.get(0));
                }
            }
            errorTable = "TMS_RESEND_INFO";
            if (this.stringUtil.hasKey(mapSchedule, Column.RESEND_ID)) {
                mapInfo = this.schedulerDao.selectResendInfo(Long.valueOf(String.valueOf(mapSchedule.get(Column.RESEND_ID)).trim()), sendId);
                if (mapInfo == null || mapInfo.size() == 0) {
                    return this.joinTableError(mapSchedule, errorTable);
                }
                if (mapInfo != null && mapInfo.size() > 0) {
                    mapSchedule.putAll(mapInfo);
                }
            }
            errorTable = "TMS_SEND_SUB_INFO";
            if (this.stringUtil.hasKey(mapSchedule, Column.SEND_ID) && (mapInfo = this.schedulerDao.selectSendSubInfo(sendId)) != null && mapInfo.size() > 0) {
                mapSchedule.putAll(mapInfo);
            }
        }
        catch (Exception e) {
            mapSchedule.put(Column.SEND_ID, sendId);
            mapSchedule.put(Column.SCHD_ID, schdId);
            return this.joinTableError(mapSchedule, errorTable);
        }
        return this.getTargetInfo(mapSchedule);
    }

    protected HashMap<String, Object> getTargetInfo(HashMap<String, Object> mapSchedule) {
        HashMap<String, Object> mapInfo = null;
        String errorTable = "TMS_TARGET_DB_INFO";
        try {
            String targetType = null;
            if (this.stringUtil.hasKey(mapSchedule, Column.TARGET_TYPE)) {
                targetType = String.valueOf(mapSchedule.get(Column.TARGET_TYPE)).trim();
            }
            if (this.stringUtil.hasKey(mapSchedule, Column.CT_TARGET_TYPE)) {
                targetType = String.valueOf(mapSchedule.get(Column.CT_TARGET_TYPE)).trim();
            }
            if (targetType.equalsIgnoreCase(Constants.TargetType.DB.name())) {
                errorTable = "TMS_TARGET_DB_INFO";
                String dbId = String.valueOf(mapSchedule.get(Column.TARGET_DB_ID));
                mapInfo = this.targeterDao.selectTargetDBInfo(dbId);
                if (mapInfo == null || mapInfo.size() == 0) {
                    return this.joinTableError(mapSchedule, errorTable);
                }
            } else if (targetType.equalsIgnoreCase(Constants.TargetType.FILE.name())) {
                errorTable = "TMS_TARGET_FILE_INFO";
                mapInfo = this.targeterDao.selectTargetFileInfo(String.valueOf(mapSchedule.get(Column.TARGET_FILE_ID)));
                if (mapInfo == null || mapInfo.size() == 0) {
                    return this.joinTableError(mapSchedule, errorTable);
                }
                if (mapInfo != null && mapInfo.size() > 0) {
                    mapSchedule.putAll(mapInfo);
                }
            }
        }
        catch (Exception e) {
            return this.joinTableError(mapSchedule, errorTable);
        }
        return mapSchedule;
    }

    protected HashMap<String, Object> joinTableError(HashMap<String, Object> mapSchedule, String tableName) {
        mapSchedule.put(Column.ERROR_CODE, "CT0502");
        mapSchedule.put(Column.DESCRIPTION, "JOIN TABLE(" + tableName + ") IS INVALID. Maybe not exist or Deleted(DEL_YN=Y)");
        return mapSchedule;
    }
}

