/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.logger;

import com.humuson.tms.config.Column;
import com.humuson.tms.controller.repository.dao.SchedulerDao;
import com.humuson.tms.controller.util.StringUtil;
import java.util.HashMap;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class StatusChanger {
    private static final Logger log = LoggerFactory.getLogger(StatusChanger.class);
    @Autowired
    protected SchedulerDao schedulerDao;
    @Value(value="${tms.company}")
    protected String company;
    @Value(value="${tms.daemon-type}")
    protected String daemonType;
    @Value(value="${tms.daemon-id}")
    protected String daemonId;
    @Value(value="${tms.controller.useSendLogHist:false}")
    protected boolean isLogging;
    @Value(value="${tms.controller.showSchdChangeLog:false}")
    protected boolean isUpdateLog;

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int updateSchedule(String JOB_STATUS, long SCHD_ID, String WORKING_YN, String MQ_PRIORITY, String description) {
        int result = this.schedulerDao.updateSchedule(JOB_STATUS, SCHD_ID, WORKING_YN, MQ_PRIORITY);
        if (result > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("METHOD", "updateSchedule");
            map.put("CODE", JOB_STATUS);
            map.put(Column.SCHD_ID, SCHD_ID);
            map.put("WORKING_YN", WORKING_YN);
            if (MQ_PRIORITY != null) {
                map.put(Column.MQ_PRIORITY, MQ_PRIORITY);
            }
            map.put("DESCRIPTION", description);
            this.insertLog(map);
        }
        return result;
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int updateTestInfo(String JOB_STATUS, long SCHD_ID, String description) {
        int result = this.schedulerDao.updateTestInfo(JOB_STATUS, SCHD_ID);
        if (result > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("METHOD", "updateTestInfo");
            map.put("CODE", JOB_STATUS);
            map.put(Column.SCHD_ID, SCHD_ID);
            map.put("DESCRIPTION", description);
            this.insertLog(map);
        }
        return result;
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public int updateResendInfo(String JOB_STATUS, long SCHD_ID, String description) {
        int result = this.schedulerDao.updateResendInfo(JOB_STATUS, SCHD_ID);
        if (result > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("METHOD", "updateResendInfo");
            map.put("CODE", JOB_STATUS);
            map.put(Column.SCHD_ID, SCHD_ID);
            map.put("DESCRIPTION", description);
            this.insertLog(map);
        }
        return result;
    }

    @Transactional(readOnly=false, rollbackFor={Exception.class})
    public void updateScheduleTarget(String JOB_STATUS, long SCHD_ID, String WORKING_YN, long INIT_TARGET, String description) {
        int result = this.schedulerDao.updateScheduleTarget(JOB_STATUS, SCHD_ID, WORKING_YN, INIT_TARGET);
        if (result > 0) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("METHOD", "updateScheduleInitTarget");
            map.put("CODE", JOB_STATUS);
            map.put(Column.SCHD_ID, SCHD_ID);
            map.put("WORKING_YN", WORKING_YN);
            map.put("DESCRIPTION", description);
            map.put("INIT_TARGET", INIT_TARGET);
            this.insertLog(map);
        }
    }

    public void insertLog(HashMap<String, Object> map) {
        if (this.isUpdateLog) {
            log.info("DB::[UPDATE] Schedule updated by {}{} ===== SCHD_ID({}), JOB_STATUS({}), Description : {}", new Object[]{this.daemonType, this.daemonId, String.valueOf(map.get(Column.SCHD_ID)), String.valueOf(map.get("CODE")), String.valueOf(map.get("DESCRIPTION"))});
        }
        if (this.isLogging) {
            map.put("DAEMON_TYPE", this.daemonType);
            map.put("DAEMON_ID", this.daemonId);
            map.put("USER_ID", this.daemonType + this.daemonId);
            JSONObject json = new JSONObject(map);
            if (json.has("DAEMON_TYPE")) {
                json.remove("DAEMON_TYPE");
            }
            if (json.has("DAEMON_ID")) {
                json.remove("DAEMON_ID");
            }
            if (json.has("USER_ID")) {
                json.remove("USER_ID");
            }
            try {
                if (json.has("DESCRIPTION")) {
                    json.put("DESCRIPTION", (Object)StringUtil.isSplitStringByte(String.valueOf(json.get("DESCRIPTION")), 3500));
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            map.put("CODE_DETAIL", json.toString());
        }
    }

    public boolean isScheduleExpectJobstatus(long SCHD_ID, String expectJobStatus) {
        HashMap<String, Object> schedule = this.schedulerDao.selectSchdInfo(SCHD_ID);
        String nowJobStatus = String.valueOf(schedule.get(Column.JOB_STATUS));
        if (nowJobStatus.trim().equalsIgnoreCase(expectJobStatus)) {
            return true;
        }
        log.warn("DB::[DETECT]Schedule JobStatus is changed By anonymous ===== expectedJobStauts : {}, but nowJobStatus : {}. This Schedule({})'s data discard in CT. not Change JOB_STATUS", new Object[]{expectJobStatus, nowJobStatus, SCHD_ID});
        return false;
    }
}

