/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.filtertarget.executor;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.controller.filtertarget.TmsPhoneNumberFilter;
import com.humuson.tms.controller.logger.FilterLogger;
import com.humuson.tms.util.StringUtils;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@TmsComponent
public class PhoneNumberFilter
implements TmsPhoneNumberFilter {
    private static final Logger log = LoggerFactory.getLogger(PhoneNumberFilter.class);
    @Autowired
    FilterLogger filterLog;

    @Override
    public HashMap<String, String> doFilter(HashMap<String, Object> mapPINFO, HashMap<String, String> mapTLIST) {
        try {
            boolean isInValidSMS = StringUtils.isSmsError((String)String.valueOf(mapTLIST.get(Column.TMS_M_TARGET)));
            if (isInValidSMS) {
                mapTLIST.put(Column.STATUS, "CT102");
                mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + String.valueOf(mapTLIST.get(Column.TMS_M_ID)) + ", phone number is invalid");
                this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, phone number is invalid ", String.valueOf(mapTLIST.get(Column.TMS_M_ID)));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mapTLIST.put(Column.STATUS, "CT103");
            mapTLIST.put(Column.LOG_DETAIL, this.getClass().getSimpleName() + " FAIL, has Exception. e: " + e);
            log.error("{} FAIL, has Exception. e:{} ", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        return mapTLIST;
    }
}

