/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.filtertarget.executor;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.controller.filtertarget.TmsMarketingAgreeFilter;
import com.humuson.tms.controller.logger.FilterLogger;
import com.humuson.tms.controller.util.RedisUtil;
import com.humuson.tms.controller.util.StringUtil;
import java.util.HashMap;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent
public class MarketingAgreeFilter
implements TmsMarketingAgreeFilter {
    private static final Logger log = LoggerFactory.getLogger(MarketingAgreeFilter.class);
    @Autowired
    FilterLogger filterLog;
    @Autowired
    RedisUtil redisUtil;
    @Autowired
    StringUtil stringUtil;
    @Value(value="${tms.controller.noUserMktFiltering:true}")
    public boolean noUserMktFiltering;

    @Override
    public HashMap<String, String> doFilter(HashMap<String, Object> mapPINFO, HashMap<String, String> mapTLIST) {
        try {
            if (this.stringUtil.isEqual(mapPINFO, Column.CHANNEL_TYPE, Constants.ChannelType.KA.name())) {
                return mapTLIST;
            }
            if (this.stringUtil.isEqual(mapPINFO, Column.CHANNEL_TYPE, Constants.ChannelType.PU.name()) && mapTLIST.get(Column.TMS_M_ID).startsWith("TMS-")) {
                return this.doBmktFilter(mapPINFO, mapTLIST);
            }
            return this.doMktFilter(mapPINFO, mapTLIST);
        }
        catch (Exception e) {
            e.printStackTrace();
            mapTLIST.put(Column.STATUS, "CT103");
            mapTLIST.put(Column.LOG_DETAIL, this.getClass().getSimpleName() + " FAIL, has Exception. e: " + e);
            log.error("{} FAIL, has Exception. e:{} ", (Object)this.getClass().getSimpleName(), (Object)e);
            return mapTLIST;
        }
    }

    public HashMap<String, String> doMktFilter(HashMap<String, Object> mapPINFO, HashMap<String, String> mapTLIST) {
        try {
            JSONObject mmktJson;
            String hashKey;
            String channelType = String.valueOf(mapPINFO.get(Column.CHANNEL_TYPE));
            String memberId = String.valueOf(mapTLIST.get(Column.TMS_M_ID));
            if (this.stringUtil.hasKey(mapTLIST, Column.MKT_EMAIL_YN) && channelType.equalsIgnoreCase(Constants.ChannelType.EM.name()) || this.stringUtil.hasKey(mapTLIST, Column.MKT_PUSH_YN) && channelType.equalsIgnoreCase(Constants.ChannelType.PU.name()) || this.stringUtil.hasKey(mapTLIST, Column.MKT_SMS_YN) && channelType.equalsIgnoreCase(Constants.ChannelType.SM.name())) {
                String mktFlag = "Y";
                if (channelType.equalsIgnoreCase(Constants.ChannelType.EM.name())) {
                    mktFlag = String.valueOf(mapTLIST.get(Column.MKT_EMAIL_YN));
                }
                if (channelType.equalsIgnoreCase(Constants.ChannelType.PU.name())) {
                    mktFlag = String.valueOf(mapTLIST.get(Column.MKT_PUSH_YN));
                }
                if (channelType.equalsIgnoreCase(Constants.ChannelType.SM.name())) {
                    mktFlag = String.valueOf(mapTLIST.get(Column.MKT_SMS_YN));
                }
                if (mktFlag.trim().equalsIgnoreCase("N")) {
                    mapTLIST.put(Column.STATUS, "CT501");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + memberId + ", MarketingYN filtering target's MarketingYN : N ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, MarketingYN filtering target's MarketingYN : N ", memberId);
                }
                return mapTLIST;
            }
            String redisKey = "MMKT:" + String.valueOf(mapPINFO.get(Column.SITE_ID));
            if (!this.redisUtil.hmHasKey(redisKey, hashKey = memberId)) {
                if (this.noUserMktFiltering) {
                    mapTLIST.put(Column.STATUS, "CT505");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + memberId + ", Marketing data is not exist. Maybe No User");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, Marketing filtering data is not exist ", memberId);
                } else {
                    return mapTLIST;
                }
            }
            if ((mmktJson = StringUtil.jsonFromJsonString(this.redisUtil.hmget(redisKey, hashKey))).getString(channelType).trim().equalsIgnoreCase("N")) {
                mapTLIST.put(Column.STATUS, "CT501");
                mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + memberId + ", Marketing filtering target's MarketingYN : N ");
                this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, Marketing filtering target's MarketingYN : N ", memberId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mapTLIST.put(Column.STATUS, "CT103");
            mapTLIST.put(Column.LOG_DETAIL, this.getClass().getSimpleName() + " FAIL, has Exception. e: " + e);
            log.error("{} FAIL, has Exception. e:{} ", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        return mapTLIST;
    }

    public HashMap<String, String> doBmktFilter(HashMap<String, Object> mapPINFO, HashMap<String, String> mapTLIST) {
        try {
            String hashKey;
            String memberId = String.valueOf(mapTLIST.get(Column.TMS_M_ID));
            if (this.stringUtil.hasKey(mapTLIST, Column.BMKT_FLAG) && mapTLIST.get(Column.BMKT_FLAG).trim().length() > 0) {
                if (mapTLIST.get(Column.BMKT_FLAG).trim().equalsIgnoreCase("N")) {
                    mapTLIST.put(Column.STATUS, "CT501");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + memberId + ", BMarketing filtering target's BMarketingYN : N ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, BMarketing filtering target's BMarketingYN : N ", memberId);
                }
                return mapTLIST;
            }
            String redisKey = "BMKT:" + String.valueOf(mapPINFO.get(Column.SITE_ID));
            if (!this.redisUtil.hmHasKey(redisKey, hashKey = mapTLIST.get(Column.DEVICE_ID))) {
                if (this.noUserMktFiltering) {
                    mapTLIST.put(Column.STATUS, "CT505");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + memberId + ", BMarketing filtering data is not exist. ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, BMarketing filtering data is not exist. ", memberId);
                    return mapTLIST;
                }
                return mapTLIST;
            }
            if (this.redisUtil.hmget(redisKey, hashKey).equalsIgnoreCase("N")) {
                mapTLIST.put(Column.STATUS, "CT501");
                mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + memberId + ", BMarketing filtering target's BMarketingYN : N ");
                this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, BMarketing filtering target's BMarketingYN : N ", memberId);
                return mapTLIST;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mapTLIST.put(Column.STATUS, "CT103");
            mapTLIST.put(Column.LOG_DETAIL, this.getClass().getSimpleName() + " FAIL, has Exception. e: " + e);
            log.error("{} FAIL, has Exception. e:{} ", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        return mapTLIST;
    }
}

