/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.filtertarget.executor;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.controller.filtertarget.TmsBasicFilter;
import com.humuson.tms.controller.filtertarget.TmsDuplicateFilter;
import com.humuson.tms.controller.filtertarget.TmsFatigueFilter;
import com.humuson.tms.controller.filtertarget.TmsFilterChain;
import com.humuson.tms.controller.filtertarget.TmsHardBounceFilter;
import com.humuson.tms.controller.filtertarget.TmsMarketingAgreeFilter;
import com.humuson.tms.controller.filtertarget.TmsMeaninglessColumnRemover;
import com.humuson.tms.controller.filtertarget.TmsPhoneNumberFilter;
import com.humuson.tms.controller.filtertarget.executor.DomainSetter;
import com.humuson.tms.controller.logger.FilterLogger;
import com.humuson.tms.controller.util.StringUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;

@TmsComponent
@Scope(value="prototype")
public class FilterChainExecutor
implements TmsFilterChain {
    private static final Logger log = LoggerFactory.getLogger(FilterChainExecutor.class);
    @Autowired
    FilterLogger filterLog;
    @Autowired
    DomainSetter domainSetter;
    @Autowired
    TmsMeaninglessColumnRemover meaninglessColumnRemover;
    @Autowired
    TmsBasicFilter basicFilter;
    @Autowired
    TmsDuplicateFilter duplicateFilter;
    @Autowired
    TmsFatigueFilter fatigueFilter;
    @Autowired
    TmsHardBounceFilter hardBounceFilter;
    @Autowired
    TmsMarketingAgreeFilter marketingAgreeFilter;
    @Autowired
    TmsPhoneNumberFilter phoneNumberFilter;
    @Autowired
    StringUtil stringUtil;

    @Override
    public HashMap<String, String> doFilterChain(HashMap<String, Object> mapPINFO, HashMap<String, String> mapTLIST) {
        try {
            String channel = String.valueOf(mapPINFO.get(Column.CHANNEL_TYPE));
            mapTLIST = this.meaninglessColumnRemover.doFilter(mapTLIST);
            mapTLIST = this.basicFilter.doFilter(mapPINFO, mapTLIST);
            mapTLIST = this.domainSetter.doSetter(mapPINFO, mapTLIST);
            if (this.stringUtil.hasKey(mapTLIST, Column.STATUS)) {
                return mapTLIST;
            }
            if (!this.stringUtil.isEqual(mapPINFO, Column.TRIGGER_METHOD, Constants.TriggerMethod.O8.name())) {
                if (this.stringUtil.isEqual(mapPINFO, Column.MKT_YN, "Y")) {
                    mapTLIST = this.marketingAgreeFilter.doFilter(mapPINFO, mapTLIST);
                }
                if (this.stringUtil.hasKey(mapTLIST, Column.STATUS)) {
                    return mapTLIST;
                }
                if (this.stringUtil.isEqual(mapPINFO, Column.FATIGUE_YN, "Y")) {
                    mapTLIST = this.fatigueFilter.doFilter(mapPINFO, mapTLIST);
                }
                if (this.stringUtil.hasKey(mapTLIST, Column.STATUS)) {
                    return mapTLIST;
                }
                if (this.stringUtil.isEqual(mapPINFO, Column.DUPLICATION_YN, "Y")) {
                    mapTLIST = this.duplicateFilter.doFilter(mapPINFO, mapTLIST);
                }
                if (this.stringUtil.hasKey(mapTLIST, Column.STATUS)) {
                    return mapTLIST;
                }
            }
            if (channel.equalsIgnoreCase(Constants.ChannelType.EM.name()) && this.stringUtil.hasKey(mapTLIST = this.hardBounceFilter.doFilter(mapPINFO, mapTLIST), Column.STATUS)) {
                return mapTLIST;
            }
            if (channel.equalsIgnoreCase(Constants.ChannelType.SM.name())) {
                mapTLIST = this.phoneNumberFilter.doFilter(mapPINFO, mapTLIST);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mapTLIST.put(Column.STATUS, "CT103");
            mapTLIST.put(Column.LOG_DETAIL, this.getClass().getSimpleName() + " FAIL, has Exception. e: " + e);
            log.error("{} FAIL, has Exception. e:{} ", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        return mapTLIST;
    }
}

