/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.filtertarget.executor;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.controller.config.CTConstants;
import com.humuson.tms.controller.filtertarget.TmsFatigueFilter;
import com.humuson.tms.controller.logger.FilterLogger;
import com.humuson.tms.controller.util.RedisUtil;
import com.humuson.tms.controller.util.StringUtil;
import com.humuson.tms.util.date.DateUtil;
import java.util.HashMap;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@TmsComponent
public class FatigueFilter
implements TmsFatigueFilter {
    private static final Logger log = LoggerFactory.getLogger(FatigueFilter.class);
    @Autowired
    FilterLogger filterLog;
    @Autowired
    RedisUtil redisUtil;

    @Override
    public HashMap<String, String> doFilter(HashMap<String, Object> mapPINFO, HashMap<String, String> mapTLIST) {
        try {
            String channelType = String.valueOf(mapPINFO.get(Column.CHANNEL_TYPE));
            String redisKey = "MFATI:" + DateUtil.getDivideDateDefault()[0] + ":" + mapPINFO.get(Column.SITE_ID);
            String redisField = mapTLIST.get(Column.TMS_M_ID);
            JSONObject redisValue = new JSONObject();
            int channelFatigueValue = 0;
            if (this.redisUtil.hmHasKey(redisKey, redisField)) {
                redisValue = StringUtil.jsonFromJsonString(this.redisUtil.hmget(redisKey, redisField));
                if (redisValue.has(channelType)) {
                    channelFatigueValue = redisValue.getInt(channelType);
                }
                if ((long)channelFatigueValue >= Long.valueOf(String.valueOf(mapPINFO.get(CTConstants.FATIGUE_DAY_LIMIT)))) {
                    mapTLIST.put(Column.STATUS, "CT502");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + String.valueOf(mapTLIST.get(Column.TMS_M_ID)) + ", KEY:" + redisKey + ", field:" + redisField + ", TMS_M_ID :" + String.valueOf(mapTLIST.get(Column.TMS_M_ID)) + ", DAY_LIMIT:" + String.valueOf(mapPINFO.get(Column.FATIGUE_DAY_LIMIT)) + ", over fatigueCount :" + channelFatigueValue);
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, KEY:{}, field:{}, TMS_M_ID: {}, DAY_LIMIT:{}, over fatigueCount :{} ", redisKey, redisField, String.valueOf(mapTLIST.get(Column.TMS_M_ID)), String.valueOf(mapPINFO.get(Column.FATIGUE_DAY_LIMIT)), channelFatigueValue);
                    return mapTLIST;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mapTLIST.put(Column.STATUS, "CT103");
            mapTLIST.put(Column.LOG_DETAIL, this.getClass().getSimpleName() + " FAIL, has Exception. e: " + e);
            log.error("{} FAIL, has Exception. e:{} ", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        return mapTLIST;
    }
}

