/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.filtertarget.executor;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.controller.filtertarget.TmsDuplicateFilter;
import com.humuson.tms.controller.logger.FilterLogger;
import com.humuson.tms.controller.util.Cryptor;
import com.humuson.tms.controller.util.RedisUtil;
import java.util.HashMap;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@TmsComponent
public class DuplicationFilter
implements TmsDuplicateFilter {
    private static final Logger log = LoggerFactory.getLogger(DuplicationFilter.class);
    @Autowired
    FilterLogger filterLog;
    @Autowired
    RedisUtil redisUtil;
    String encryptKey = null;
    @Autowired
    TmsCommonConfig tmsCommonConfig;

    @PostConstruct
    public void onPost() {
        this.encryptKey = this.tmsCommonConfig.getHumusonKey();
    }

    @Override
    public HashMap<String, String> doFilter(HashMap<String, Object> mapPINFO, HashMap<String, String> mapTLIST) {
        try {
            String target = Cryptor.encryptMtarget(mapTLIST.get(Column.TMS_M_TARGET), this.encryptKey);
            String duptRedisKey = "TDUPT:" + String.valueOf(mapPINFO.get(Column.SEND_ID));
            String duptRedisFiled = mapTLIST.get(Column.TMS_M_ID) + ":" + target;
            long value = this.redisUtil.hincrby(duptRedisKey, duptRedisFiled, 1L);
            if (value > 1L) {
                mapTLIST.put(Column.STATUS, "CT503");
                mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + String.valueOf(mapTLIST.get(Column.TMS_M_ID)) + ", duplicated count :" + value);
                this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, duplicated count :{} ", String.valueOf(mapTLIST.get(Column.TMS_M_ID)), value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mapTLIST.put(Column.STATUS, "CT103");
            mapTLIST.put(Column.LOG_DETAIL, this.getClass().getSimpleName() + " FAIL, has Exception. e: " + e);
            log.error("{} FAIL, has Exception. e:{} ", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        return mapTLIST;
    }
}

