/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.filtertarget.executor;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.controller.filtertarget.TmsDomainSetter;
import com.humuson.tms.controller.logger.FilterLogger;
import com.humuson.tms.controller.util.StringUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@TmsComponent
public class DomainSetter
implements TmsDomainSetter {
    private static final Logger log = LoggerFactory.getLogger(DomainSetter.class);
    @Autowired
    FilterLogger filterLog;
    @Autowired
    StringUtil stringUtil;

    @Override
    public HashMap<String, String> doSetter(HashMap<String, Object> mapPINFO, HashMap<String, String> mapTLIST) {
        try {
            String channel;
            String status = "";
            if (this.stringUtil.hasKey(mapTLIST, Column.STATUS)) {
                status = String.valueOf(mapPINFO.get(Column.LOG_DETAIL)) + ", ";
            }
            if ((channel = String.valueOf(mapPINFO.get(Column.CHANNEL_TYPE))).equalsIgnoreCase(Constants.ChannelType.EM.name())) {
                String domain = StringUtil.getDomain(String.valueOf(mapTLIST.get(Column.TMS_M_EMAIL)));
                if (domain == null || domain.trim().isEmpty()) {
                    mapTLIST.put(Column.DOMAIN, "NO_DOMAIN");
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, status + "TMS_M_ID :" + String.valueOf(mapTLIST.get(Column.TMS_M_ID)) + ", email domain is not exist");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, domain is not exist  ", String.valueOf(mapTLIST.get(Column.TMS_M_ID)));
                } else {
                    mapTLIST.put(Column.DOMAIN, domain);
                }
            } else if (channel.equalsIgnoreCase(Constants.ChannelType.PU.name())) {
                if (!this.stringUtil.hasKey(mapTLIST, Column.OS)) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.DOMAIN, "NO_DOMAIN");
                    mapTLIST.put(Column.LOG_DETAIL, status + "TMS_M_ID :" + String.valueOf(mapTLIST.get(Column.TMS_M_ID)) + ", OS is not exist");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, OS is not exist  ", String.valueOf(mapTLIST.get(Column.TMS_M_ID)));
                    return mapTLIST;
                }
                if (String.valueOf(mapTLIST.get(Column.OS)).equalsIgnoreCase("A")) {
                    mapTLIST.put(Column.DOMAIN, Column.ANDROID);
                } else if (String.valueOf(mapTLIST.get(Column.OS)).equalsIgnoreCase("I")) {
                    mapTLIST.put(Column.DOMAIN, Column.APNS);
                }
            } else if (channel.equalsIgnoreCase(Constants.ChannelType.KA.name())) {
                if (!this.stringUtil.hasKey(mapPINFO, Column.CHANNEL_TYPE_SUB)) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.DOMAIN, "NO_DOMAIN");
                    mapTLIST.put(Column.LOG_DETAIL, status + "TMS_M_ID :" + String.valueOf(mapTLIST.get(Column.TMS_M_ID)) + ", CHANNEL_TYPE_SUB is not exist");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, CHANNEL_TYPE_SUB is not exist  ", String.valueOf(mapTLIST.get(Column.TMS_M_ID)));
                    return mapTLIST;
                }
                mapTLIST.put(Column.DOMAIN, String.valueOf(mapPINFO.get(Column.CHANNEL_TYPE_SUB)));
            } else if (channel.equalsIgnoreCase(Constants.ChannelType.SM.name())) {
                mapTLIST.put(Column.DOMAIN, "SMS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mapTLIST.put(Column.STATUS, "CT103");
            mapTLIST.put(Column.LOG_DETAIL, this.getClass().getSimpleName() + " FAIL, has Exception. e: " + e);
            log.error("{} FAIL, has Exception. e:{} ", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        return mapTLIST;
    }
}

