/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.filtertarget.executor;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.controller.config.CTConstants;
import com.humuson.tms.controller.filtertarget.TmsBasicFilter;
import com.humuson.tms.controller.logger.FilterLogger;
import com.humuson.tms.controller.util.StringUtil;
import com.humuson.tms.util.StringUtils;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@TmsComponent
public class BasicInfoFilter
implements TmsBasicFilter {
    private static final Logger log = LoggerFactory.getLogger(BasicInfoFilter.class);
    @Autowired
    FilterLogger filterLog;
    @Autowired
    StringUtil stringUtil;

    @Override
    public HashMap<String, String> doFilter(HashMap<String, Object> mapPINFO, HashMap<String, String> mapTLIST) {
        String channel = String.valueOf(mapPINFO.get(Column.CHANNEL_TYPE));
        String appGrpId = mapPINFO.containsKey(Column.APP_GRP_ID) ? String.valueOf(mapPINFO.get(Column.APP_GRP_ID)) : "0";
        try {
            if (this.stringUtil.hasKey(mapTLIST, Column.STATUS)) {
                this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), " TARGETER FAIL, TMS_M_ID({}) has STATUS({}). will delete STATUS", String.valueOf(mapTLIST.get(Column.TMS_M_ID)), String.valueOf(mapTLIST.get(Column.STATUS)));
                mapTLIST.remove(Column.STATUS);
            }
            if (!this.stringUtil.hasKey(mapTLIST, Column.TMS_M_ID) || BasicInfoFilter.isInvalidId(String.valueOf(mapTLIST.get(Column.TMS_M_ID)))) {
                mapTLIST.put(Column.STATUS, "CT102");
                mapTLIST.put(Column.LOG_DETAIL, "original TMS_M_ID is NULL or EMPTY or INVALID data. will change INVALID_ID");
                if (!this.stringUtil.hasKey(mapTLIST, Column.TMS_M_ID)) {
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID null or empty, TMS_M_ID  will change :{} ", String.valueOf(mapTLIST.get(Column.TMS_M_ID)), "INVALID_ID");
                } else {
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, TMS_M_ID  will change :{} ", String.valueOf(mapTLIST.get(Column.TMS_M_ID)), "INVALID_ID");
                }
                mapTLIST.put(Column.TMS_M_ID, "INVALID_ID");
                return mapTLIST;
            }
            String id = String.valueOf(mapTLIST.get(Column.TMS_M_ID));
            if (!this.stringUtil.hasKey(mapTLIST, "DEL_YN") && this.stringUtil.isEqual(mapTLIST, "DEL_YN", "Y")) {
                mapTLIST.put(Column.STATUS, "CT102");
                mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", DEL_YN : " + String.valueOf(mapTLIST.get("DEL_YN")));
                this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), " TARGETER FAIL, TMS_M_ID {}, DEL_YN : {}  ", id, String.valueOf(mapTLIST.get("DEL_YN")));
                return mapTLIST;
            }
            if (channel.equalsIgnoreCase(Constants.ChannelType.EM.name())) {
                if (!this.stringUtil.hasKey(mapTLIST, Column.TMS_M_EMAIL) && !this.stringUtil.hasKey(mapTLIST, Column.TMS_M_TARGET) || !String.valueOf(mapTLIST.get(Column.TMS_M_EMAIL)).contains("@") && !String.valueOf(mapTLIST.get(Column.TMS_M_TARGET)).contains("@")) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", Email address is invalid ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, Email address is invalid  ", id);
                    return mapTLIST;
                }
                mapTLIST.put(Column.TMS_M_TARGET, mapTLIST.get(Column.TMS_M_EMAIL));
                if (StringUtils.isEmailError((String)String.valueOf(mapTLIST.get(Column.TMS_M_EMAIL)))) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", Email address is invalid ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, Email address is invalid  ", id);
                    return mapTLIST;
                }
                Matcher matcher = CTConstants.VALID_EMAIL_ADDRESS_REGEX.matcher(String.valueOf(mapTLIST.get(Column.TMS_M_EMAIL)));
                if (!matcher.find()) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", Email address is invalid ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, Email address is invalid  ", id);
                    return mapTLIST;
                }
            } else if (channel.equalsIgnoreCase(Constants.ChannelType.SM.name()) || channel.equalsIgnoreCase(Constants.ChannelType.KA.name())) {
                if (!this.stringUtil.hasKey(mapTLIST, Column.TMS_M_PHONE) && !this.stringUtil.hasKey(mapTLIST, Column.TMS_M_TARGET)) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", Phone number is not exist");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, Phone number is not exist.  ", id);
                    return mapTLIST;
                }
                mapTLIST.put(Column.TMS_M_TARGET, mapTLIST.get(Column.TMS_M_PHONE));
            } else if (channel.equalsIgnoreCase(Constants.ChannelType.PU.name())) {
                if (Long.valueOf(appGrpId) == 0L) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", PINFO's APP_GRP_ID is not exist");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, PInfo's APP_GRP_ID is not exist  ", id);
                    return mapTLIST;
                }
                if (this.stringUtil.hasKey(mapTLIST, Column.APP_GRP_ID) && !String.valueOf(mapTLIST.get(Column.APP_GRP_ID)).equalsIgnoreCase(appGrpId)) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", PINFO's APP_GRP_ID(" + appGrpId + ") is not equal Target's APP_GRP_ID(" + String.valueOf(mapTLIST.get(Column.APP_GRP_ID)) + ")");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, PInfo's APP_GRP_ID({}) is not equal Target's APP_GRP_ID({})", id, appGrpId, String.valueOf(mapTLIST.get(Column.APP_GRP_ID)));
                    return mapTLIST;
                }
                if (!this.stringUtil.hasKey(mapTLIST, Column.TMS_M_TOKEN) && !this.stringUtil.hasKey(mapTLIST, Column.TMS_M_TARGET)) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", TMS_M_TOKEN is not exist ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, TMS_M_TOKEN is not exist ", id);
                    return mapTLIST;
                }
                if (String.valueOf(mapTLIST.get(Column.TMS_M_TOKEN)).equalsIgnoreCase(Column.NO_TOKEN)) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", TMS_M_TOKEN is noToken ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, TMS_M_TOKEN is noToken  ", id);
                    return mapTLIST;
                }
                if (String.valueOf(mapTLIST.get(Column.TMS_M_TOKEN)).trim().equalsIgnoreCase("null")) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", TMS_M_TOKEN is null ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, TMS_M_TOKEN is null  ", id);
                    return mapTLIST;
                }
                if (!this.stringUtil.hasKey(mapTLIST, Column.DEVICE_ID)) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", DEVICE_ID is not exist ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, DEVICE_ID is not exist ", id);
                    return mapTLIST;
                }
                if (!this.stringUtil.hasKey(mapTLIST, Column.NOTI_FLAG)) {
                    mapTLIST.put(Column.STATUS, "CT102");
                    mapTLIST.put(Column.LOG_DETAIL, "TMS_M_ID :" + id + ", NOTI_FLAG is not exist ");
                    this.filterLog.info(mapPINFO, this.getClass().getSimpleName(), "TARGETER FAIL, TMS_M_ID {}, NOTI_FLAG is not exist ", id);
                    return mapTLIST;
                }
                mapTLIST.put(Column.TMS_M_TARGET, mapTLIST.get(Column.TMS_M_TOKEN));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mapTLIST.put(Column.STATUS, "CT103");
            mapTLIST.put(Column.LOG_DETAIL, this.getClass().getSimpleName() + " FAIL, has Exception. e: " + e);
            log.error("{} FAIL, has Exception. e:{} ", (Object)this.getClass().getSimpleName(), (Object)e);
        }
        return mapTLIST;
    }

    public static boolean isInvalidId(String id) {
        try {
            if (id.trim().isEmpty()) {
                return true;
            }
            if (Pattern.matches(".*[\u3131-\u314e\u314f-\u3163\uac00-\ud7a3]+.*.", id)) {
                return true;
            }
        }
        catch (PatternSyntaxException e) {
            return true;
        }
        return false;
    }
}

