/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.filtercommon.executor;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.annotation.TmsComponent;
import com.humuson.tms.controller.filtercommon.TmsPINFOFilter;
import com.humuson.tms.controller.util.StringUtil;
import com.humuson.tms.util.date.DateUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

@TmsComponent
public class PINFOFilter
implements TmsPINFOFilter {
    private static final Logger log = LoggerFactory.getLogger(PINFOFilter.class);
    @Autowired
    protected StringUtil<Object> stringUtil;
    @Value(value="${tms.controller.usingExpireHour:false}")
    protected boolean usingExpireHour;

    @Override
    public HashMap<String, Object> execute(HashMap<String, Object> mapSchedule) {
        if (this.stringUtil.hasKey(mapSchedule, Column.ERROR_CODE)) {
            mapSchedule.remove(Column.ERROR_CODE);
        }
        if (this.stringUtil.hasKey(mapSchedule, Column.JOB_STATUS)) {
            mapSchedule.remove(Column.JOB_STATUS);
        }
        if (this.stringUtil.hasKey(mapSchedule, "SEND_JOB_STATUS")) {
            mapSchedule.remove("SEND_JOB_STATUS");
        }
        return this.doFilter(mapSchedule);
    }

    private HashMap<String, Object> doFilter(HashMap<String, Object> mapSchedule) {
        if (this.stringUtil.hasKey(mapSchedule, "RESEND_JOB_STATUS") && !String.valueOf(mapSchedule.get(Column.TRIGGER_METHOD)).equalsIgnoreCase(Constants.TriggerMethod.O8.name()) && Long.valueOf(String.valueOf(mapSchedule.get("RESEND_JOB_STATUS"))) >= 40L) {
            return this.dataError(mapSchedule, "TMS_RESEND_INFO's JOB_STATUS =" + String.valueOf(mapSchedule.get("SEND_JOB_STATUS")));
        }
        if (!this.stringUtil.hasKey(mapSchedule, Column.CHANNEL_TYPE)) {
            return this.dataError(mapSchedule, Column.CHANNEL_TYPE);
        }
        if (String.valueOf(mapSchedule.get(Column.CHANNEL_TYPE)).equalsIgnoreCase(Constants.ChannelType.EM.name())) {
            if (!this.stringUtil.hasKey(mapSchedule, Column.FROM_NAME)) {
                return this.dataError(mapSchedule, Column.FROM_NAME);
            }
            if (!this.stringUtil.hasKey(mapSchedule, Column.FROM_EMAIL)) {
                return this.dataError(mapSchedule, Column.FROM_EMAIL);
            }
            if (!this.stringUtil.hasKey(mapSchedule, Column.RETURN_PATH)) {
                mapSchedule = this.dataError(mapSchedule, Column.RETURN_PATH);
                return mapSchedule;
            }
        } else if (String.valueOf(mapSchedule.get(Column.CHANNEL_TYPE)).equalsIgnoreCase(Constants.ChannelType.SM.name()) && !this.stringUtil.hasKey(mapSchedule, Column.FROM_NUMBER)) {
            return this.dataError(mapSchedule, Column.FROM_NUMBER);
        }
        if (!this.stringUtil.hasKey(mapSchedule, Column.CAMP_ID)) {
            return this.dataError(mapSchedule, Column.CAMP_ID);
        }
        if (!this.stringUtil.hasKey(mapSchedule, Column.SEND_ID)) {
            return this.dataError(mapSchedule, Column.SEND_ID);
        }
        if (!this.stringUtil.hasKey(mapSchedule, Column.CONTENT_ID)) {
            return this.dataError(mapSchedule, Column.CONTENT_ID);
        }
        if (!this.stringUtil.hasKey(mapSchedule, Column.SEND_ADD_ID)) {
            return this.dataError(mapSchedule, Column.SEND_ADD_ID);
        }
        if (!this.stringUtil.hasKey(mapSchedule, Column.CHANNEL_ID)) {
            return this.dataError(mapSchedule, Column.CHANNEL_ID);
        }
        if (!this.stringUtil.hasKey(mapSchedule, Column.TRIGGER_METHOD)) {
            return this.dataError(mapSchedule, Column.TRIGGER_METHOD);
        }
        if (!this.stringUtil.isEqual(mapSchedule, Column.TRIGGER_METHOD, Constants.TriggerMethod.F1.name())) {
            if (!this.stringUtil.hasKey(mapSchedule, Column.SCHD_ID)) {
                return this.dataError(mapSchedule, Column.SCHD_ID);
            }
            if (!this.stringUtil.hasKey(mapSchedule, Column.SCHD_TARGET_ID)) {
                return this.dataError(mapSchedule, Column.SCHD_TARGET_ID);
            }
            if (!this.stringUtil.hasKey(mapSchedule, Column.TARGET_ID)) {
                return this.dataError(mapSchedule, Column.TARGET_ID);
            }
        }
        mapSchedule = this.targetInfoFilter(mapSchedule);
        return this.isExpiredSchedule(mapSchedule);
    }

    private HashMap<String, Object> targetInfoFilter(HashMap<String, Object> mapSchedule) {
        String targetType = null;
        if (this.stringUtil.hasKey(mapSchedule, Column.TARGET_TYPE)) {
            String.valueOf(mapSchedule.get(Column.TARGET_TYPE)).trim();
        }
        if (this.stringUtil.hasKey(mapSchedule, Column.CT_TARGET_TYPE)) {
            targetType = String.valueOf(mapSchedule.get(Column.CT_TARGET_TYPE)).trim();
        }
        if (targetType == null) {
            return this.dataError(mapSchedule, Column.CT_TARGET_TYPE);
        }
        if (targetType.equalsIgnoreCase(Constants.TargetType.DB.name())) {
            if (!this.stringUtil.hasKey(mapSchedule, Column.TARGET_DB_ID)) {
                return this.dataError(mapSchedule, Column.TARGET_DB_ID);
            }
        } else if (targetType.equalsIgnoreCase(Constants.TargetType.FILE.name())) {
            if (!this.stringUtil.hasKey(mapSchedule, Column.TARGET_FILE_ID)) {
                return this.dataError(mapSchedule, Column.TARGET_FILE_ID);
            }
            if (!this.stringUtil.hasKey(mapSchedule, Column.TARGET_FILE_ENCODING)) {
                return this.dataError(mapSchedule, Column.TARGET_FILE_ENCODING);
            }
            if (!this.stringUtil.hasKey(mapSchedule, Column.TARGET_FILE_HEAD_FLAG)) {
                return this.dataError(mapSchedule, Column.TARGET_FILE_HEAD_FLAG);
            }
            if (!this.stringUtil.hasKey(mapSchedule, Column.TARGET_FILE_IDX)) {
                return this.dataError(mapSchedule, Column.TARGET_FILE_IDX);
            }
            if (!this.stringUtil.hasKey(mapSchedule, Column.ENCRYPT_YN)) {
                return this.dataError(mapSchedule, Column.ENCRYPT_YN);
            }
        }
        return mapSchedule;
    }

    private HashMap<String, Object> isExpiredSchedule(HashMap<String, Object> mapSchedule) {
        try {
            if (Constants.TriggerMethod.F1.name().equalsIgnoreCase(String.valueOf(mapSchedule.get(Column.TRIGGER_METHOD)))) {
                return mapSchedule;
            }
            long expireHour = -1L;
            if (this.usingExpireHour) {
                expireHour = Long.valueOf(String.valueOf(mapSchedule.get(Column.EXPIRE_HOUR)));
            }
            if (expireHour == -1L) {
                return mapSchedule;
            }
            String reqDate = String.valueOf(mapSchedule.get(Column.REQ_DATE));
            SimpleDateFormat sdf = DateUtil.getSimpleDateFormat();
            sdf.applyPattern("yyyy-MM-dd HH:mm:ss");
            Date d1 = sdf.parse(reqDate.substring(0, reqDate.indexOf(".")));
            long diff = System.currentTimeMillis() - d1.getTime();
            long diffHours = diff / 3600000L % 24L;
            if (diffHours > expireHour) {
                mapSchedule.put(Column.ERROR_CODE, "CT0604");
                mapSchedule.put(Column.DESCRIPTION, String.valueOf(mapSchedule.get(Column.ERROR_CODE)) + "||" + String.valueOf(mapSchedule.get(Column.SCHD_ID)) + "|TMS_SCHD_INFO REQ_DATE OVER THAN VALIDATE TIME. its's over than " + (diffHours - expireHour) + " Hours.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            mapSchedule.put(Column.ERROR_CODE, "CT0501");
            mapSchedule.put(Column.DESCRIPTION, String.valueOf(mapSchedule.get(Column.ERROR_CODE)) + "||" + String.valueOf(mapSchedule.get(Column.SCHD_ID)) + "|Controller has Exception. " + this.getClass().getSimpleName() + " : " + e);
        }
        return mapSchedule;
    }

    private HashMap<String, Object> dataError(HashMap<String, Object> mapSchedule, String columnName) {
        mapSchedule.put(Column.ERROR_CODE, "CT0503");
        mapSchedule.put(Column.DESCRIPTION, "PINFO FILTERING. INVALID DATA : " + columnName);
        return mapSchedule;
    }
}

