/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.config;

import com.humuson.tms.adaptor.jdbc.mybatis.DefaultDatabaseConfig;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.BatchConfigurationException;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.repository.support.JobRepositoryFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.DependsOn;
import org.springframework.core.task.TaskExecutor;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.support.DefaultTransactionDefinition;

@Component
@Configuration
@EnableBatchProcessing
@DependsOn(value={"defaultDatabaseConfig"})
public class BatchConfiguration {
    private static final Logger log = LoggerFactory.getLogger(BatchConfiguration.class);
    @Autowired
    @Qualifier(value="tmsDatasource")
    private DataSource dataSource;
    @Autowired
    PlatformTransactionManager transactionManager;
    @Autowired
    DefaultDatabaseConfig databaseConfig;
    @Value(value="${tms.controller.job-thread-pool.once.core-pool:-1}")
    private int nmCorePoolSize;
    @Value(value="${tms.controller.job-thread-pool.once.max-pool:-1}")
    private int nmMaxPoolSize;
    @Value(value="${tms.controller.job-thread-pool.once.capacity:-1}")
    private int nmQueueCapacity;
    @Value(value="${tms.controller.job-thread-pool.once.keepAliveSeconds:-1}")
    private int nmKeepAliveSeconds;
    @Value(value="${tms.controller.job-thread-pool.once.waitForTasksToCompleteOnShutdown:true}")
    private boolean nmIsWait;
    @Value(value="${tms.controller.job-thread-pool.cycle.core-pool:-1}")
    private int cycleCorePoolSize;
    @Value(value="${tms.controller.job-thread-pool.cycle.max-pool:-1}")
    private int cycleMaxPoolSize;
    @Value(value="${tms.controller.job-thread-pool.cycle.capacity:-1}")
    private int cycleQueueCapacity;
    @Value(value="${tms.controller.job-thread-pool.cycle.keepAliveSeconds:-1}")
    private int cycleKeepAliveSeconds;
    @Value(value="${tms.controller.job-thread-pool.cycle.waitForTasksToCompleteOnShutdown:true}")
    private boolean cycleIsWait;

    @Bean(name={"tmsJobRepository"})
    public JobRepository getJobRepository() {
        JobRepositoryFactoryBean factoryBean = new JobRepositoryFactoryBean();
        if (this.databaseConfig.getDefaultDBType().name().equals("MARIA")) {
            factoryBean.setDatabaseType("MYSQL");
        } else {
            factoryBean.setDatabaseType(this.databaseConfig.getDefaultDBType().name());
        }
        factoryBean.setDataSource(this.dataSource);
        factoryBean.setTransactionManager(this.getDataSourceTransactionManager());
        factoryBean.setIsolationLevelForCreate("ISOLATION_READ_COMMITTED");
        try {
            factoryBean.afterPropertiesSet();
            return factoryBean.getObject();
        }
        catch (Exception e) {
            log.error("JobRepository bean could not be initialized");
            throw new BatchConfigurationException((Throwable)e);
        }
    }

    private PlatformTransactionManager getDataSourceTransactionManager() {
        DefaultTransactionDefinition defaultTransactionDefinition = new DefaultTransactionDefinition();
        defaultTransactionDefinition.setPropagationBehavior(0);
        defaultTransactionDefinition.setIsolationLevel(2);
        DataSourceTransactionManager dataSourceTransactionManager = new DataSourceTransactionManager(this.dataSource);
        dataSourceTransactionManager.getTransaction((TransactionDefinition)defaultTransactionDefinition);
        return dataSourceTransactionManager;
    }

    @Bean(value={"job.ct.normal"})
    public SimpleJobLauncher jobLauncher(JobRepository jobRepository) throws Exception {
        SimpleJobLauncher simpleJobLauncher = new SimpleJobLauncher();
        simpleJobLauncher.setJobRepository(this.getJobRepository());
        simpleJobLauncher.setTaskExecutor(this.normalTaskExecutor());
        simpleJobLauncher.afterPropertiesSet();
        log.info("[BatchJobConfig] JobLauncher(job.ct.normal) bean set");
        return simpleJobLauncher;
    }

    @Bean(value={"task.ct.normal"})
    public TaskExecutor normalTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        if (this.nmCorePoolSize >= 0) {
            taskExecutor.setCorePoolSize(this.nmCorePoolSize);
        }
        if (this.nmMaxPoolSize >= 0) {
            taskExecutor.setMaxPoolSize(this.nmMaxPoolSize);
        }
        if (this.nmQueueCapacity >= 0) {
            taskExecutor.setQueueCapacity(this.nmQueueCapacity);
        }
        if (this.nmKeepAliveSeconds >= 0) {
            taskExecutor.setKeepAliveSeconds(this.nmKeepAliveSeconds);
        }
        taskExecutor.setWaitForTasksToCompleteOnShutdown(this.nmIsWait);
        taskExecutor.setThreadGroupName("task.ct.normal");
        taskExecutor.setThreadNamePrefix("ctNormalTask-");
        return taskExecutor;
    }

    @Bean(value={"job.ct.cycle"})
    public SimpleJobLauncher cycleJobLauncher(JobRepository jobRepository) throws Exception {
        SimpleJobLauncher simpleJobLauncher = new SimpleJobLauncher();
        simpleJobLauncher.setJobRepository(this.getJobRepository());
        simpleJobLauncher.setTaskExecutor(this.cycleTaskExecutor());
        simpleJobLauncher.afterPropertiesSet();
        log.info("[BatchJobConfig] JobLauncher(job.ct.cycle) bean set");
        return simpleJobLauncher;
    }

    @Bean(value={"task.ct.cycle"})
    public TaskExecutor cycleTaskExecutor() {
        ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();
        if (this.cycleCorePoolSize >= 0) {
            taskExecutor.setCorePoolSize(this.cycleCorePoolSize);
        }
        if (this.cycleMaxPoolSize >= 0) {
            taskExecutor.setMaxPoolSize(this.cycleMaxPoolSize);
        }
        if (this.cycleQueueCapacity >= 0) {
            taskExecutor.setQueueCapacity(this.cycleQueueCapacity);
        }
        if (this.cycleKeepAliveSeconds >= 0) {
            taskExecutor.setKeepAliveSeconds(this.cycleKeepAliveSeconds);
        }
        taskExecutor.setWaitForTasksToCompleteOnShutdown(this.cycleIsWait);
        taskExecutor.setThreadGroupName("task.ct.cycle");
        taskExecutor.setThreadNamePrefix("ctCycleTask-");
        return taskExecutor;
    }
}

