/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.batch.writer;

import com.humuson.tms.adaptor.jdbc.mybatis.TmsJdbcError;
import com.humuson.tms.config.Column;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.controller.logger.StatusChanger;
import com.humuson.tms.controller.module.CancleChecker;
import com.humuson.tms.controller.module.RedisKeyMaker;
import com.humuson.tms.controller.module.result.ResultBatchHandler;
import com.humuson.tms.controller.repository.dao.SchedulerDao;
import com.humuson.tms.controller.repository.dao.TargeterDao;
import com.humuson.tms.controller.util.JobParameterUtil;
import com.humuson.tms.controller.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;

public abstract class TmsWriter {
    private static final Logger log = LoggerFactory.getLogger(TmsWriter.class);
    @Autowired
    LockContexter lockContexter;
    @Value(value="${tms.controller.ct-tlist-unit:1000}")
    public int ctTlistUnit;
    @Autowired
    StringUtil<String> stringUtil;
    @Autowired
    JobParameterUtil jobParameterUtil;
    @Autowired
    SchedulerDao schedulerDao;
    @Autowired
    TargeterDao targeterDao;
    @Autowired
    StatusChanger statusChanger;
    @Autowired
    CancleChecker cancleChecker;
    @Autowired
    RedisKeyMaker redisKeyMaker;
    @Autowired
    @Qualifier(value="ResultBatchHandler")
    ResultBatchHandler resultSender;
    String encryptKey = null;
    @Autowired
    TmsCommonConfig tmsCommonConfig;

    @PostConstruct
    public void onPost() {
        this.encryptKey = this.tmsCommonConfig.getHumusonKey();
    }

    protected HashMap<String, Object> getJobParamToMap(StepExecution stepExecution) {
        return this.jobParameterUtil.getMapFromJobParam(stepExecution.getJobExecution().getJobParameters());
    }

    protected HashMap<String, String> getStringJobParamToMap(StepExecution stepExecution) {
        return this.jobParameterUtil.getStringMapFromJobParam(stepExecution.getJobExecution().getJobParameters());
    }

    protected HashMap<String, String> stepMergeToPINFO(HashMap<String, String> mapPINFO, StepExecution stepExecution) {
        long sprocInitCount = stepExecution.getExecutionContext().getLong("INIT_TARGET", 0L);
        long sprocDoneCount = stepExecution.getExecutionContext().getLong("COUNT_TARGET", 0L);
        long sprocFailedCount = stepExecution.getExecutionContext().getLong("FAILED_TARGET", 0L);
        long targetSeq = stepExecution.getExecutionContext().getLong(Column.TARGET_SEQ, 0L);
        mapPINFO.put(Column.TARGET_SEQ, targetSeq + "");
        mapPINFO.put("INIT_TARGET", sprocInitCount + "");
        mapPINFO.put("COUNT_TARGET", sprocDoneCount + "");
        mapPINFO.put("FAILED_TARGET", sprocFailedCount + "");
        mapPINFO.put("KEY_CRSLT", this.redisKeyMaker.CRSLTKey(mapPINFO));
        mapPINFO.put("KEY_TLIST", this.redisKeyMaker.TLISTKey(mapPINFO));
        mapPINFO.put("KEY_TFAIL", this.redisKeyMaker.TFAILCTKey(mapPINFO));
        return mapPINFO;
    }

    public HashMap<String, ArrayList<HashMap<String, String>>> removeErrorTarget(ArrayList<HashMap<String, String>> iteratedItems, List<TmsJdbcError> jdbcErrorList) {
        HashMap<String, ArrayList<HashMap<String, String>>> resultMap = new HashMap<String, ArrayList<HashMap<String, String>>>();
        try {
            if (jdbcErrorList != null && jdbcErrorList.size() > 0) {
                ArrayList<HashMap> failedItems = new ArrayList<HashMap>();
                Iterator<HashMap<String, String>> listItr = iteratedItems.iterator();
                while (listItr.hasNext()) {
                    HashMap<String, String> target = listItr.next();
                    for (int i = 0; i < jdbcErrorList.size(); ++i) {
                        Map erroredTaret = jdbcErrorList.get(i).getMappingInfo();
                        if (erroredTaret == null || erroredTaret.size() <= 0) continue;
                        String targetMemberId = target.get("TMS_M_ID").toString();
                        String targetUniqueSeq = target.get("UNIQUE_SEQ").toString();
                        String erroredMemberId = erroredTaret.get("TMS_M_ID").toString();
                        String erroredUniqueSeq = erroredTaret.get("UNIQUE_SEQ").toString();
                        if (!targetMemberId.equalsIgnoreCase(erroredMemberId) || !targetUniqueSeq.equalsIgnoreCase(erroredUniqueSeq)) continue;
                        target.put(Column.STATUS, "CT701");
                        target.put(Column.LOG_DETAIL, jdbcErrorList.get(i).getException().toString());
                        failedItems.add((HashMap)target.clone());
                        listItr.remove();
                    }
                }
                resultMap.put("TARGET_FAIL", failedItems);
            }
            resultMap.put("TARGET_SUCCESS", iteratedItems);
        }
        catch (Exception e) {
            log.error("ERROR.  : {}", (Throwable)e);
            resultMap.put("TARGET_SUCCESS", null);
            resultMap.put("TARGET_FAIL", this.allListErrored(iteratedItems, e));
        }
        return resultMap;
    }

    public ArrayList<HashMap<String, String>> allListErrored(ArrayList<HashMap<String, String>> items, Exception e) {
        for (HashMap<String, String> target : items) {
            target.put(Column.STATUS, "CT701");
            if (e == null) {
                target.put(Column.LOG_DETAIL, "Update Has Error. More Check Log and source.");
                continue;
            }
            target.put(Column.LOG_DETAIL, "Update Has Error. errorName : " + e.getMessage());
        }
        return items;
    }
}

