/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.batch.processor;

import com.humuson.tms.config.Column;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.controller.filtertarget.executor.FilterChainExecutor;
import com.humuson.tms.controller.module.result.ResultDBHandler;
import com.humuson.tms.controller.targeter.TmsInefficientTargeter;
import com.humuson.tms.controller.util.Cryptor;
import com.humuson.tms.controller.util.JobParameterUtil;
import com.humuson.tms.controller.util.StringUtil;
import com.humuson.tms.util.date.DateUtil;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import oracle.sql.CLOB;
import org.json.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class TargetProcessor
implements ItemProcessor<HashMap<String, Object>, HashMap<String, String>> {
    private static final Logger log = LoggerFactory.getLogger(TargetProcessor.class);
    @Autowired
    Cryptor cryptor;
    @Autowired
    FilterChainExecutor filter;
    @Autowired
    TmsInefficientTargeter inefficientTargeter;
    @Autowired
    StringUtil stringUtil;
    @Autowired
    JobParameterUtil jobParameterUtil;
    @Autowired
    @Qualifier(value="ResultDBHandler")
    ResultDBHandler resultSender;
    String encryptKey = null;
    @Autowired
    TmsCommonConfig tmsCommonConfig;
    protected StepExecution stepExecution;

    @PostConstruct
    public void onPost() {
        this.encryptKey = this.tmsCommonConfig.getHumusonKey();
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        stepExecution.getExecutionContext().putString(Column.ENCRYPT_KEY, this.encryptKey);
        stepExecution.getExecutionContext().putLong("INIT_TARGET", 0L);
        stepExecution.getExecutionContext().putLong("COUNT_TARGET", 0L);
        stepExecution.getExecutionContext().putLong("FAILED_TARGET", 0L);
        stepExecution.getExecutionContext().putLong(Column.UNIQUE_SEQ, 0L);
        stepExecution.getExecutionContext().put("UserCancleException", (Object)"N");
        stepExecution.getExecutionContext().putLong(Column.TARGET_SEQ, this.resultSender.getPinfoNextTargetSeq(stepExecution.getJobExecution().getJobParameters().getString(Column.SCHD_ID)));
    }

    public HashMap<String, String> process(HashMap<String, Object> items) {
        return this.doProcessing(items);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> doProcessing(HashMap<String, Object> items) {
        HashMap<String, Object> mapPINFO = this.jobParameterUtil.getMapFromJobParam(this.stepExecution.getJobExecution().getJobParameters());
        mapPINFO.put(Column.TARGET_SEQ, this.stepExecution.getExecutionContext().getLong(Column.TARGET_SEQ));
        this.stepExecution.getExecutionContext().putLong("INIT_TARGET", this.stepExecution.getExecutionContext().getLong("INIT_TARGET", 0L) + 1L);
        long uniqueSeq = this.stepExecution.getExecutionContext().getLong(Column.UNIQUE_SEQ, 0L);
        try {
            if (items == null) {
                log.error("Target:'s targeting fail. target is null");
                this.stepExecution.getExecutionContext().putLong("FAILED_TARGET", this.stepExecution.getExecutionContext().getLong("FAILED_TARGET") + 1L);
                HashMap<String, String> hashMap = null;
                return hashMap;
            }
            HashMap<String, String> mapTLIST = this.stringUtil.convertStringMap(items);
            String plainEtc = null;
            try {
                Object jsonEtc = null;
                while (this.stringUtil.hasKey(mapTLIST, Column.ETC)) {
                    try {
                        String etcColumn = null;
                        BufferedReader bufferRead = null;
                        StringBuffer str = null;
                        if (items.get(Column.ETC) instanceof CLOB) {
                            try {
                                String strng;
                                str = new StringBuffer();
                                CLOB clob = (CLOB)items.get(Column.ETC);
                                bufferRead = new BufferedReader(clob.getCharacterStream());
                                while ((strng = bufferRead.readLine()) != null) {
                                    str.append(strng);
                                }
                                etcColumn = str.toString();
                            }
                            catch (Exception clob) {
                            }
                            finally {
                                if (bufferRead != null) {
                                    bufferRead.close();
                                    bufferRead = null;
                                }
                                str = null;
                            }
                        } else {
                            etcColumn = mapTLIST.get(Column.ETC);
                        }
                        JSONObject resultJSON = new JSONObject();
                        JSONParser parser = new JSONParser();
                        Object obj = parser.parse(etcColumn);
                        resultJSON = (JSONObject)obj;
                        mapTLIST.remove(Column.ETC);
                        for (Object o : resultJSON.entrySet()) {
                            Map.Entry e = (Map.Entry)o;
                            String key = (String)e.getKey();
                            if (this.stringUtil.hasKey(mapTLIST, key) || key.equalsIgnoreCase(Column.TMS_M_ID) && mapTLIST.get(Column.TMS_M_ID) != null && mapTLIST.containsKey(Column.TMS_M_ID) || key.equalsIgnoreCase(Column.TMS_M_EMAIL) && mapTLIST.get(Column.TMS_M_EMAIL) != null && mapTLIST.containsKey(Column.TMS_M_EMAIL) || key.equalsIgnoreCase(Column.TMS_M_PHONE) && mapTLIST.get(Column.TMS_M_PHONE) != null && mapTLIST.containsKey(Column.TMS_M_PHONE) || key.equalsIgnoreCase(Column.TMS_M_TOKEN) && mapTLIST.get(Column.TMS_M_TOKEN) != null && mapTLIST.containsKey(Column.TMS_M_TOKEN)) continue;
                            if (resultJSON.containsKey((Object)key) && resultJSON.get((Object)key) != null) {
                                mapTLIST.put(key, String.valueOf(resultJSON.get((Object)key)).trim());
                                continue;
                            }
                            mapTLIST.put(key, "null");
                        }
                    }
                    catch (Exception e) {
                        log.error("Exception. ETC column is not JSONObject. error : {}, ETC :{}", (Object)e.getMessage(), (Object)mapTLIST.get(Column.ETC));
                        plainEtc = mapTLIST.get(Column.ETC);
                        mapTLIST.remove(Column.ETC);
                    }
                }
            }
            catch (Exception e) {
                log.error("Exception {}", (Throwable)e);
            }
            finally {
                if (plainEtc != null && !plainEtc.trim().isEmpty()) {
                    mapTLIST.put(Column.ETC, plainEtc);
                }
            }
            List<Object> listMultiTarget = new ArrayList();
            listMultiTarget = this.inefficientTargeter.doTargeting(mapPINFO, mapTLIST);
            if (listMultiTarget == null || listMultiTarget.size() == 0) {
                listMultiTarget.add(mapTLIST);
            }
            JSONArray arrJson = new JSONArray();
            for (int i = 0; i < listMultiTarget.size(); ++i) {
                ArrayList<String> arrStr;
                HashMap<String, String> target = (HashMap<String, String>)listMultiTarget.get(i);
                if (this.stringUtil.hasKey(target, Column.TARGET_TEMP_ID) && !((String)target.get(Column.TARGET_TEMP_ID)).trim().isEmpty() && !this.stringUtil.isEqual(mapPINFO, Column.TRIGGER_METHOD, Constants.TriggerMethod.O8.name())) {
                    target.put(Column.UNIQUE_SEQ, (String)target.get(Column.TARGET_TEMP_ID));
                } else {
                    target.put(Column.UNIQUE_SEQ, String.valueOf(mapPINFO.get(Column.TARGET_SEQ)) + ++uniqueSeq + "");
                }
                target.put(Column.TRIGGER_METHOD, String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD)));
                target = this.cryptor.decryptMap(target, this.encryptKey);
                target = this.filter.doFilterChain(mapPINFO, target);
                target.put(Column.WORKDAY, String.valueOf(mapPINFO.get(Column.WORKDAY)));
                target.put(Column.SEND_ID, String.valueOf(mapPINFO.get(Column.SEND_ID)));
                target.put(Column.SCHD_ID, String.valueOf(mapPINFO.get(Column.SCHD_ID)));
                target.put(Column.TARGET_ID, String.valueOf(mapPINFO.get(Column.TARGET_ID)));
                target.put(Column.CHANNEL_TYPE, String.valueOf(mapPINFO.get(Column.CHANNEL_TYPE)));
                target.put(Column.TARGET_SEQ, String.valueOf(mapPINFO.get(Column.TARGET_SEQ)));
                target.put(Column.TARGET_SEQ, String.valueOf(mapPINFO.get(Column.TARGET_SEQ)));
                target.put(Column.REG_ID, String.valueOf(mapPINFO.get(Column.REG_ID)));
                if (this.stringUtil.hasKey(target, Column.LOG_DETAIL)) {
                    arrStr = StringUtil.isSplitListByte(String.valueOf(target.get(Column.LOG_DETAIL)), 400);
                    target.put(Column.LOG_DETAIL, arrStr.get(0));
                }
                if (this.stringUtil.hasKey(target, Column.TMS_M_NAME)) {
                    arrStr = StringUtil.isSplitListByte(String.valueOf(target.get(Column.TMS_M_NAME)), 100);
                    target.put("CT_MEMBER_NAME", arrStr.get(0));
                }
                if (!this.stringUtil.hasKey(target, Column.DEVICE_ID)) {
                    target.put(Column.DEVICE_ID, "0");
                }
                target.put("CT_MEMBER_ID_SEQ", String.valueOf(target.get(Column.UNIQUE_SEQ)));
                target.put("CT_MEMBER_ID", String.valueOf(target.get(Column.TMS_M_ID)));
                if (this.stringUtil.hasKey(target, Column.STATUS)) {
                    target.put("CT_CODE_DETAIL", String.valueOf(target.get(Column.STATUS)));
                }
                target.put("CT_EVENT_TIME", DateUtil.getFullDate((String)"yyyyMMddHHmmss"));
                target.put("CT_EVENT_TYPE", "T");
                if (!this.stringUtil.hasKey(target, Column.DOMAIN)) {
                    this.stepExecution.getExecutionContext().putLong("FAILED_TARGET", this.stepExecution.getExecutionContext().getLong("FAILED_TARGET") + 1L);
                    mapTLIST = new HashMap();
                    if (uniqueSeq <= 0L) continue;
                    --uniqueSeq;
                    continue;
                }
                if (i == 0) {
                    mapTLIST = new HashMap();
                    mapTLIST = target;
                    continue;
                }
                arrJson.put(target);
            }
            if (arrJson.length() > 0) {
                mapTLIST.put(Column.MULTI_TARGET_JSON_LIST, arrJson.toString());
            }
            if (mapTLIST == null || mapTLIST.size() == 0) {
                HashMap<String, String> hashMap = null;
                return hashMap;
            }
            this.stepExecution.getExecutionContext().putLong(Column.UNIQUE_SEQ, uniqueSeq);
            listMultiTarget = null;
            HashMap<String, String> hashMap = mapTLIST;
            return hashMap;
        }
        catch (Exception exTFAIL) {
            log.error("Target:'s targeting fail. has Exception. {}", (Throwable)exTFAIL);
            this.stepExecution.getExecutionContext().putLong("FAILED_TARGET", this.stepExecution.getExecutionContext().getLong("FAILED_TARGET") + 1L);
            HashMap<String, String> hashMap = null;
            return hashMap;
        }
        finally {
            mapPINFO.clear();
        }
    }
}

