/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.controller.batch;

import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.config.Column;
import com.humuson.tms.controller.batch.processor.TargetProcessor;
import com.humuson.tms.controller.batch.writer.TargetItemWriter;
import com.humuson.tms.controller.module.result.ResultDBHandler;
import com.humuson.tms.controller.util.JobParameterUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.EnableBatchProcessing;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.launch.support.SimpleJobLauncher;
import org.springframework.batch.core.step.tasklet.TaskletStep;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.stereotype.Component;

@Component
@Configuration
@EnableBatchProcessing
public class BatchLauncher {
    private static final Logger log = LoggerFactory.getLogger(BatchLauncher.class);
    @Autowired
    @Qualifier(value="ResultDBHandler")
    ResultDBHandler resultSender;
    @Autowired
    StepBuilderFactory stepBuilderFactory;
    @Autowired
    JobBuilderFactory jobBuilderFactory;
    @Autowired
    @Qualifier(value="job.ct.normal")
    SimpleJobLauncher jobLauncherOnce;
    @Autowired
    @Qualifier(value="job.ct.cycle")
    SimpleJobLauncher jobLauncherCycle;
    @Autowired
    JobParameterUtil jobParameterUtil;
    @Value(value="${tms.controller.batch.chunk-unit:1000}")
    public int batchChunkUnit;
    @Value(value="${tms.controller.batch.throttle-limit:5}")
    public int batchThrottleLimit;

    public void execute(long sendId, long schdId, HashMap<String, Object> mapPINFO, ItemReader<HashMap<String, Object>> itemReader) {
        try {
            JobParameters jobParameters = this.jobParameterUtil.getJobParamFromMap(mapPINFO);
            ItemProcessor itemProcessor = (ItemProcessor)ClassDispatcher.getApplicationContext().getBean(TargetProcessor.class);
            ItemWriter itemWriter = (ItemWriter)ClassDispatcher.getApplicationContext().getBean(TargetItemWriter.class);
            TaskletStep step = this.stepBuilderFactory.get(String.valueOf(mapPINFO.get(Column.STEP_NAME))).chunk(this.batchChunkUnit).reader(itemReader).processor(itemProcessor).writer(itemWriter).build();
            Job job = this.jobBuilderFactory.get(String.valueOf(mapPINFO.get(Column.JOB_NAME))).start((Step)step).build();
            String triggerMethod = String.valueOf(mapPINFO.get(Column.TRIGGER_METHOD));
            if (triggerMethod.startsWith("O")) {
                log.info("BatchLauncher. Job :job.ct.normal,  jobName : {} . START", (Object)String.valueOf(mapPINFO.get(Column.JOB_NAME)));
                this.jobLauncherOnce.run(job, jobParameters);
            } else if (triggerMethod.startsWith("C")) {
                log.info("BatchLauncher. Job :job.ct.cycle,  jobName : {} . START", (Object)String.valueOf(mapPINFO.get(Column.JOB_NAME)));
                this.jobLauncherCycle.run(job, jobParameters);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("{}|{}|{}|BATCH EXCEPTION. {} : {}", new Object[]{"CT0505", sendId, schdId, this.getClass().getSimpleName(), e});
            this.resultSender.updateSchdError(sendId, schdId, e.getMessage());
        }
    }
}

