/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.validator;

import java.util.Set;
import java.util.function.Function;
import javax.annotation.PostConstruct;
import javax.validation.ConstraintViolation;
import javax.validation.Validation;
import javax.validation.Validator;

public class ValidatorUtil<T> {
    private Validator validator;
    private Function<ConstraintViolation<T>, String> defaultFunction = cv -> cv.getPropertyPath() + "=" + cv.getInvalidValue() + ":" + cv.getMessage() + "|";

    @PostConstruct
    public void init() {
        this.validator = Validation.buildDefaultValidatorFactory().getValidator();
    }

    public String validating(T t) {
        return this.defaultValidating(t, this.defaultFunction);
    }

    public String defaultValidating(T t, Function<ConstraintViolation<T>, String> fun) {
        Set violations = this.validator.validate(t, new Class[0]);
        StringBuilder sb = new StringBuilder();
        for (ConstraintViolation violation : violations) {
            sb.append(fun.apply(violation));
        }
        return sb.toString();
    }

    public boolean isValidating(T t, Function<ConstraintViolation<T>, String> fun) {
        Set violations = this.validator.validate(t, new Class[0]);
        return violations.size() > 0;
    }
}

