/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.net;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger log = LoggerFactory.getLogger(HttpUtil.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String jsonCallUrlPost(String doUrl, String jsonString) throws Exception {
        StringBuilder sb = new StringBuilder();
        String http = doUrl;
        HttpURLConnection urlConnection = null;
        try {
            URL url = new URL(http);
            urlConnection = (HttpURLConnection)url.openConnection();
            urlConnection.setDoOutput(true);
            urlConnection.setRequestMethod("POST");
            urlConnection.setUseCaches(false);
            urlConnection.setConnectTimeout(50000);
            urlConnection.setReadTimeout(50000);
            urlConnection.setRequestProperty("Content-Type", "application/json");
            urlConnection.connect();
            OutputStreamWriter out = new OutputStreamWriter(urlConnection.getOutputStream());
            out.write(jsonString);
            out.close();
            int HttpResult = urlConnection.getResponseCode();
            if (HttpResult == 200) {
                BufferedReader br = new BufferedReader(new InputStreamReader(urlConnection.getInputStream(), "utf-8"));
                String line = null;
                while ((line = br.readLine()) != null) {
                    sb.append(line + "\n");
                }
                br.close();
                String string = sb.toString();
                return string;
            }
            log.error(" ", (Object)("" + urlConnection.getResponseMessage()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (urlConnection != null) {
                urlConnection.disconnect();
            }
        }
        return null;
    }

    public static String jsonCallUrl(String url) throws Exception {
        BufferedReader in = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            StringBuffer response = new StringBuffer();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                log.info("Response Code : " + responseCode);
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                String string = response.toString().trim();
                return string;
            }
            String string = "" + responseCode;
            return string;
        }
        catch (Exception e) {
            log.error("failed call http url[{}] Exception ", (Object)url, (Object)e);
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                connection = null;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                log.error("[se] retry error {}", (Object)url, (Object)e2);
            }
        }
    }
}

