/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.log.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.LoggerFactory;

public enum LogFileContext {
    REQUEST_ACCEPT("/request", "/request.log"),
    SENDED_MESSAGE("/send", "/send.log"),
    RESULT_ACCEPT("/result", "/result.log"),
    RESPONSE_MESSAGE("/response", "/response.log");

    private final String id;
    private final String path;
    private String fileName;
    private static Map<String, Logger> loggers;

    private LogFileContext(String path, String fileName) {
        this.id = path;
        this.fileName = fileName;
        this.path = "";
    }

    public Logger log() {
        if (loggers.containsKey(this.id)) {
            return loggers.get(this.id);
        }
        return LogFileContext.getLogger(this.id, this.path);
    }

    public static synchronized Logger createLogger(String id, String fullPathFileName) {
        return LogFileContext.getLogger(id, fullPathFileName);
    }

    public static synchronized Logger getLogger(String string, String fullPathFileName, String pattern) {
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        PatternLayoutEncoder ple = new PatternLayoutEncoder();
        ple.setPattern(pattern);
        ple.setContext((Context)lc);
        ple.start();
        FileAppender fileAppender = new FileAppender();
        fileAppender.setFile(fullPathFileName);
        fileAppender.setEncoder((Encoder)ple);
        fileAppender.setContext((Context)lc);
        fileAppender.start();
        Logger logger = (Logger)LoggerFactory.getLogger((String)string);
        logger.addAppender((Appender)fileAppender);
        logger.setLevel(Level.INFO);
        logger.setAdditive(false);
        loggers.put(string, logger);
        return logger;
    }

    private static Logger getLogger(String id, String fullPathFileName) {
        return LogFileContext.getLogger(id, fullPathFileName, "%date %level [%thread] %logger{10} [%file:%line] %msg%n");
    }

    public static void main(String[] args) {
        REQUEST_ACCEPT.log().info("abcdefg");
    }

    static {
        loggers = new ConcurrentHashMap<String, Logger>();
    }
}

