/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.log.logback;

import com.humuson.tms.config.ClassDispatcher;
import com.humuson.tms.util.log.logback.ErrorCodeConfiguration;
import com.humuson.tms.util.log.logback.ErrorLevelProcessor;
import java.util.Map;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ErrorCodeContainer {
    INSTANCE;

    ErrorCodeConfiguration errorCodeConfiguration;
    Map<String, String> errorCodes;
    Map<String, String> errorRules;
    Map<String, ErrorLevelProcessor> errorCodeRules = new TreeMap<String, ErrorLevelProcessor>();
    protected Logger log = LoggerFactory.getLogger((String)"systemTraceLog");

    private ErrorCodeContainer() {
        this.errorCodeConfiguration = (ErrorCodeConfiguration)ClassDispatcher.getApplicationContext().getBean(ErrorCodeConfiguration.class);
        this.errorRules = this.errorCodeConfiguration.getRule();
        this.errorCodes = this.errorCodeConfiguration.getCore();
        for (String key : this.errorCodes.keySet()) {
            String[] codes = this.errorCodes.get(key).split(",");
            if (!this.errorRules.containsKey(codes[0])) continue;
            ErrorLevelProcessor processor = this.createInstance(this.errorRules.get(codes[0]));
            if (processor == null) {
                this.log.error("error processor not existed in this error code[{}]. skip", (Object)codes[0]);
            }
            this.errorCodeRules.put(key, processor);
        }
    }

    private ErrorLevelProcessor createInstance(String message) {
        String[] errorProcessors = message.split(",");
        ErrorLevelProcessor processor = null;
        ErrorLevelProcessor chainProcessor = null;
        for (String errorProcessor : errorProcessors) {
            try {
                if (processor == null) {
                    chainProcessor = processor = (ErrorLevelProcessor)ClassDispatcher.getBean(errorProcessor.trim());
                    continue;
                }
                chainProcessor = chainProcessor.addProcessor((ErrorLevelProcessor)ClassDispatcher.getBean(errorProcessor.trim()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        try {
            return processor;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void errorProcessing(String code, String message) {
        if (this.errorCodeRules.containsKey(code)) {
            ErrorLevelProcessor errorProcessor = this.errorCodeRules.get(code);
            errorProcessor.processing(message);
        }
    }
}

