/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.log.logback;

import com.humuson.tms.util.log.logback.ErrorCodeConfiguration;
import com.humuson.tms.util.log.logback.ErrorLevelProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BasicErrorLevelProcessor
implements ErrorLevelProcessor {
    private static final Logger log = LoggerFactory.getLogger(BasicErrorLevelProcessor.class);
    @Autowired
    ErrorCodeConfiguration errorCodeConfiguration;
    ErrorLevelProcessor nextErrorProcessor;
    protected int errorCountInCycleTime;
    long lastSendingTime;

    public boolean isOverLastProcessingTime() {
        long nowTime = System.currentTimeMillis() / 60000L;
        if (nowTime <= this.lastSendingTime + (long)this.errorCodeConfiguration.getMinCycle()) {
            return false;
        }
        this.lastSendingTime = nowTime;
        this.errorCountInCycleTime = 0;
        return true;
    }

    @Override
    public void processing(String message) {
        if (!this.isOverLastProcessingTime()) {
            if (log.isDebugEnabled()) {
                log.debug("this error message is skip. message={}", (Object)message);
            }
            ++this.errorCountInCycleTime;
            return;
        }
        try {
            this.alermErrorEvent(message);
            if (this.nextErrorProcessor != null) {
                this.nextErrorProcessor.processing(message);
            }
        }
        catch (Exception e) {
            log.error("alerm error event error message[{}]", (Object)message, (Object)e);
        }
    }

    protected abstract void alermErrorEvent(String var1);

    @Override
    public ErrorLevelProcessor addProcessor(ErrorLevelProcessor errorLevelProcessor) {
        this.nextErrorProcessor = errorLevelProcessor;
        return this.nextErrorProcessor;
    }
}

