/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.license;

import com.humuson.tms.crypto.HumusonDecryptor;
import com.humuson.tms.util.date.DateUtil;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class LicenseJudge {
    private static final Logger log = LoggerFactory.getLogger(LicenseJudge.class);
    public boolean isPassedLicense;
    @Value(value="${tms.license}")
    private String licenseKey;
    @Value(value="${tms.company}")
    private String company;
    private static String INFINITI_PERIOD = "9999";

    @Autowired
    public void setLicense() {
        log.info("licenseKey : {}", (Object)this.licenseKey);
        String decriptStr = "";
        try {
            InetAddress local = InetAddress.getLocalHost();
            String localIp = local.getHostAddress();
            String today = DateUtil.getFullDate("yyyyMMdd");
            boolean dateOut = true;
            if (this.licenseKey == null || this.company == null || localIp == null || today == null) {
                this.isPassedLicense = false;
                log.error("license necessary param is null");
            } else {
                decriptStr = HumusonDecryptor.decrypt(this.licenseKey);
                if (decriptStr == null) {
                    this.isPassedLicense = false;
                    log.error("licenseKey decrypt fail");
                } else {
                    String[] decryptKeys = decriptStr.split("[|]");
                    if (decryptKeys != null && decryptKeys.length == 3) {
                        dateOut = INFINITI_PERIOD.equals(decryptKeys[2]) ? false : DateUtil.checkTimeoutSecondToNow(0, decryptKeys[2] + "000000");
                        if (this.company.equals(decryptKeys[0]) && localIp.equals(decryptKeys[1]) && !dateOut) {
                            log.info(">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>license pass");
                            this.isPassedLicense = true;
                        } else {
                            log.error("license is not match : {} {} {}", new Object[]{this.company, localIp, dateOut});
                        }
                    } else {
                        log.error("licenseKey pasing fail");
                    }
                }
            }
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
        }
        this.isPassedLicense = this.isMasterKey(decriptStr, this.isPassedLicense);
        if (!this.isPassedLicense) {
            log.error("is not license");
            System.exit(-1);
        }
    }

    private String getServerHostIp() {
        String hostAddr = null;
        try {
            Enumeration<NetworkInterface> nienum = NetworkInterface.getNetworkInterfaces();
            while (nienum.hasMoreElements()) {
                NetworkInterface ni = nienum.nextElement();
                Enumeration<InetAddress> kk = ni.getInetAddresses();
                while (kk.hasMoreElements()) {
                    InetAddress inetAddress = kk.nextElement();
                    log.info("inetAddress ip : {}", hostAddr);
                    if (inetAddress.isLoopbackAddress() || inetAddress.isLinkLocalAddress() || !inetAddress.isSiteLocalAddress()) continue;
                    hostAddr = inetAddress.getHostAddress().toString();
                    log.info("local ip : {}", (Object)hostAddr);
                }
            }
            InetAddress local = InetAddress.getLocalHost();
            log.info("My PC IP :" + local.getHostAddress());
        }
        catch (Exception e) {
            log.error("{}", (Throwable)e);
        }
        return hostAddr;
    }

    private boolean isMasterKey(String deStr, boolean nowStatus) {
        if ("kswpjyljsktssmj".equals(deStr)) {
            return true;
        }
        return nowStatus;
    }
}

