/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.json;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tms.monitor.ProgressStatusInfo;
import com.humuson.tms.monitor.command.AbstractMonitorCommand;
import com.humuson.tms.monitor.command.DelayMonitorCommand;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class JsonConvertUtil {
    public static <T extends Serializable> String objectToJsonString(T t) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(t);
    }

    public static String beanToJsonString(Object o) throws Exception {
        return new ObjectMapper().writeValueAsString(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> String listBeanToJsonString(List<T> o) throws Exception {
        try (StringWriter sw = new StringWriter();){
            ObjectMapper mapper = new ObjectMapper();
            mapper.writeValue((Writer)sw, o);
            String string = sw.toString();
            return string;
        }
    }

    public static <T extends Serializable> String mapToJsonString(Map t) throws Exception {
        return new ObjectMapper().writeValueAsString((Object)t);
    }

    public static <T extends Serializable> T jsonStringToObject(String jsonString, Class<T> clz) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (T)((Serializable)mapper.readValue(jsonString, clz));
    }

    public static void main(String[] args) throws Exception {
        ProgressStatusInfo status = new ProgressStatusInfo("DS01");
        status.setDate(new Date());
        status.setMenu("menu");
        status.setMessage("message");
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("channel", "EM");
        status.setAddtionInfo(map);
        status.setEvent(ProgressStatusInfo.MonitorEvent.CPU);
        DelayMonitorCommand command = new DelayMonitorCommand();
        command.setName("Delay");
        command.setLevel(10);
        command.setRun(false);
        status.setMonitorCommand(command);
        String jsonString = JsonConvertUtil.objectToJsonString(status);
        System.out.println(jsonString);
        ProgressStatusInfo o = JsonConvertUtil.jsonStringToObject(jsonString, ProgressStatusInfo.class);
        AbstractMonitorCommand runCommand = o.getMonitorCommand();
        System.out.println(runCommand.isRun());
        System.out.println(o);
    }
}

