/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.date;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import org.apache.commons.lang.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DateUtil {
    private static final Logger log = LoggerFactory.getLogger(DateUtil.class);
    static SimpleDateFormat simpleDateFormat;

    public static String getFullDateDefaultFormat() {
        return DateUtil.getFullDate("yyyyMMddHHmmss");
    }

    public static String nextDate(String date) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
        Calendar c = Calendar.getInstance();
        Date d = sdf.parse(date);
        c.setTime(d);
        c.add(5, 1);
        return sdf.format(c.getTime());
    }

    public static String getFullDate(String format) {
        FastDateFormat fdf = FastDateFormat.getInstance((String)format);
        Date dateObj = new Date();
        String today = fdf.format(dateObj);
        return today;
    }

    public static String getFullDate(String format, Date date) {
        FastDateFormat fdf = FastDateFormat.getInstance((String)format);
        String today = fdf.format(date);
        return today;
    }

    public static String[] getDivideDateDefault() {
        String[] dates = new String[2];
        String date = DateUtil.getFullDate("yyyyMMddHHmmss");
        dates[0] = date.substring(0, 8);
        dates[1] = date.substring(8, 14);
        return dates;
    }

    public static String getYesterdayWorkday() {
        Calendar cal = Calendar.getInstance();
        cal.add(5, -1);
        return DateUtil.getFullDate("yyyyMMdd", cal.getTime());
    }

    public static String getWorkday() {
        Calendar cal = Calendar.getInstance();
        return DateUtil.getFullDate("yyyyMMdd", cal.getTime());
    }

    public static String getDateCalculationDay(String format, int cntDay) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(5, cntDay);
        return DateUtil.getFullDate(format, cal.getTime());
    }

    public static String getDateEndTime() {
        Calendar cal = Calendar.getInstance();
        cal.set(11, 23);
        cal.set(12, 59);
        cal.set(13, 59);
        return DateUtil.getFullDate("yyyy-MM-dd HH:mm:ss", cal.getTime());
    }

    public static String getAfterTime(String format, int term, int termFormat) {
        GregorianCalendar cal = new GregorianCalendar();
        ((Calendar)cal).add(termFormat, term);
        return DateUtil.getFullDate(format, cal.getTime());
    }

    public static String addDate(String format, int term) {
        return DateUtil.getDateCalculationDay(format, term);
    }

    public static boolean checkTimeoutSecondToNow(int stand, String targetTime) {
        boolean result = false;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            Date nowDate = sdf.parse(DateUtil.getFullDateDefaultFormat());
            Date targetDate = sdf.parse(targetTime);
            long diff = nowDate.getTime() - targetDate.getTime();
            long sec = diff / 1000L;
            if (sec > (long)stand) {
                result = true;
            }
        }
        catch (Exception e) {
            log.debug("checkTimeoutSecondToNow has exception:{}", (Throwable)e);
        }
        return result;
    }

    public static SimpleDateFormat getSimpleDateFormat() {
        if (simpleDateFormat == null) {
            simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
        return simpleDateFormat;
    }

    public static String getNowDate(String outputFormat) {
        SimpleDateFormat sdf = new SimpleDateFormat();
        sdf.applyPattern(outputFormat);
        sdf.setTimeZone(TimeZone.getTimeZone("Asia/Seoul"));
        return sdf.format(new Date().getTime());
    }

    public static void main(String[] args) {
        log.info(DateUtil.getFullDateDefaultFormat());
        log.info(DateUtil.getFullDate("yyyyMMddHHmm"));
    }
}

