/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.convert;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.humuson.tms.monitor.ProgressStatusInfo;
import com.humuson.tms.monitor.command.AbstractMonitorCommand;
import com.humuson.tms.monitor.command.DelayMonitorCommand;
import com.humuson.tms.util.json.JsonConvertUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(TransObjectUtil.class);

    public static <T extends Serializable> String objectToJsonString(T t) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString(t);
    }

    public static <T extends Serializable> T jsonStringToObject(String jsonString, Class<T> clz) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        return (T)((Serializable)mapper.readValue(jsonString, clz));
    }

    public static Map<String, Object> convertObjectToMap(Object obj) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            Method[] methods;
            Class<?> pomclass = obj.getClass();
            pomclass = obj.getClass();
            for (Method m : methods = obj.getClass().getMethods()) {
                if (!m.getName().startsWith("get") || m.getName().startsWith("getClass")) continue;
                Object value = m.invoke(obj, new Object[0]);
                map.put(m.getName().substring(3), value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.error("error bean[{}] to map change. return null", obj, (Object)e);
            return null;
        }
        return map;
    }

    public static Map<String, Object> ConverObjectToMap(Object obj) {
        try {
            Field[] fields = obj.getClass().getDeclaredFields();
            HashMap<String, Object> resultMap = new HashMap<String, Object>();
            for (int i = 0; i <= fields.length - 1; ++i) {
                fields[i].setAccessible(true);
                resultMap.put(fields[i].getName(), fields[i].get(obj));
            }
            return resultMap;
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException el) {
            el.printStackTrace();
        }
        return null;
    }

    public static <T> T mapToBean(Class<T> resultType, Map<String, Object> map) {
        try {
            T t = resultType.newInstance();
            BeanUtils.populate(t, map);
            return t;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("map[{}] to bean[{}] change error. next continue..", map, (Object)resultType.getName());
            return null;
        }
        catch (InstantiationException e) {
            log.error("create new Instance error. \nmap[{}] to bean[{}] next continue..", map, (Object)resultType.getName());
            e.printStackTrace();
            return null;
        }
    }

    public static <K, V> boolean mapEqualsOnLeftSide(Map<K, V> leftMap, Map<K, V> rightMap) {
        if (leftMap == rightMap) {
            return true;
        }
        if (leftMap == null || rightMap == null) {
            return false;
        }
        for (K key : leftMap.keySet()) {
            V value1 = leftMap.get(key);
            V value2 = rightMap.get(key);
            if (value1 == null && value2 == null) continue;
            if (value1 == null || value2 == null) {
                return false;
            }
            if (value1.equals(value2)) continue;
            return false;
        }
        return true;
    }

    public static void main1(String[] args) {
        HashMap<String, Object> lMap = new HashMap<String, Object>();
        HashMap<String, Object> rMap = new HashMap<String, Object>();
        lMap.put("String", "text1");
        lMap.put("Integer", 1);
        rMap.put("String", "text1");
        rMap.put("Integer", 1);
        rMap.put("Integer2", 2);
        System.out.println(TransObjectUtil.mapEqualsOnLeftSide(lMap, rMap));
    }

    public static void main(String[] args) throws Exception {
        ProgressStatusInfo status = new ProgressStatusInfo("DS01");
        status.setDate(new Date());
        status.setMenu("menu");
        status.setMessage("message");
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        map.put("channel", "EM");
        status.setAddtionInfo(map);
        status.setEvent(ProgressStatusInfo.MonitorEvent.CPU);
        DelayMonitorCommand command = new DelayMonitorCommand();
        command.setName("Delay");
        command.setLevel(10);
        command.setRun(false);
        status.setMonitorCommand(command);
        String jsonString = JsonConvertUtil.objectToJsonString(status);
        System.out.println(jsonString);
        ProgressStatusInfo o = JsonConvertUtil.jsonStringToObject(jsonString, ProgressStatusInfo.class);
        AbstractMonitorCommand runCommand = o.getMonitorCommand();
        System.out.println(runCommand.isRun());
        System.out.println(o);
    }
}

