/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.chunk;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadExecutorCountAnalyzer
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(ThreadExecutorCountAnalyzer.class);
    private final ThreadPoolExecutor threadPoolExecutor;
    private final int timeDiff;

    public ThreadExecutorCountAnalyzer(ExecutorService executorService, int timeDiff) throws Exception {
        this.timeDiff = timeDiff;
        if (!(executorService instanceof ThreadPoolExecutor)) {
            throw new Exception();
        }
        this.threadPoolExecutor = (ThreadPoolExecutor)executorService;
    }

    public int activeCount() {
        return this.threadPoolExecutor.getActiveCount();
    }

    public int poolSize() {
        return this.threadPoolExecutor.getPoolSize();
    }

    public int maximumPoolSize() {
        return this.threadPoolExecutor.getMaximumPoolSize();
    }

    public boolean isShutdown() {
        return this.threadPoolExecutor.isShutdown();
    }

    @Override
    public void run() {
        if (this.threadPoolExecutor != null) {
            while (true) {
                if (this.threadPoolExecutor.getActiveCount() > 1) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Thread[{}] Report:: Active:{} Pool: {} MaxPool: {} ", new Object[]{this.threadPoolExecutor.getClass().getName(), this.threadPoolExecutor.getActiveCount(), this.threadPoolExecutor.getPoolSize(), this.threadPoolExecutor.getMaximumPoolSize()});
                    continue;
                }
                try {
                    Thread.sleep(this.timeDiff);
                }
                catch (InterruptedException e) {
                    log.error("thread[{}] sleep error", (Object)this.timeDiff, (Object)e);
                }
            }
        }
    }
}

