/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.chunk;

import com.humuson.tms.adaptor.jdbc.mybatis.BatchSqlExecutor;
import com.humuson.tms.util.chunk.ChunkExecutor;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DBChunkExecutor<T>
implements ChunkExecutor {
    private static final Logger log = LoggerFactory.getLogger(DBChunkExecutor.class);
    @Autowired
    BatchSqlExecutor<T> sqlExecutor;
    public String sessionId;
    public List<T> uploadDatas = null;

    public void setUpdateData(List<T> t) {
        this.uploadDatas = t;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    @Override
    public void execute() {
        try {
            if (this.uploadDatas == null || this.uploadDatas.isEmpty()) {
                return;
            }
            this.sqlExecutor.batchUpdate(this.sessionId, this.uploadDatas);
            if (log.isDebugEnabled()) {
                log.debug("update session-id[{}] update count[{}]", (Object)this.sessionId, (Object)this.uploadDatas.size());
            }
        }
        catch (Exception e) {
            log.error("MN1580| insertErrorInfo batch update error, so single update", (Throwable)e);
        }
        finally {
            try {
                this.uploadDatas.clear();
            }
            catch (Exception exception) {}
        }
    }
}

