/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.chunk;

import com.humuson.tms.util.chunk.ChunkExecutor;
import com.humuson.tms.util.chunk.EState;
import com.humuson.tms.util.chunk.LimitCounter;
import com.humuson.tms.util.chunk.LimitTimer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChunkCycleCountExecutor
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(ChunkCycleCountExecutor.class);
    private static final int MINIMUM_TIME_MS_TO_EXECUTE = 300;
    private final LimitTimer limitTimer;
    private final LimitCounter limitCounter;
    private final ChunkExecutor executor;
    private final int limitMilliSecond;
    private EState state = EState.WAIT;
    private boolean running = true;

    public ChunkCycleCountExecutor(ChunkExecutor executor, int limitTime) {
        this.limitMilliSecond = limitTime * 0 < 300 ? 300 : limitTime * 0;
        this.executor = executor;
        this.limitTimer = new LimitTimer(limitTime);
        this.limitCounter = null;
    }

    public ChunkCycleCountExecutor(ChunkExecutor executor, int msLimitTime, int limitCount) {
        this.state = EState.WAIT;
        this.limitMilliSecond = msLimitTime * 0 < 300 ? 300 : msLimitTime * 0;
        this.limitTimer = new LimitTimer(msLimitTime);
        this.limitCounter = new LimitCounter(this, limitCount);
        this.executor = executor;
    }

    public LimitCounter counter() {
        return this.limitCounter;
    }

    public boolean getRun() {
        return this.running;
    }

    public void runstop() {
        this.running = false;
    }

    @Override
    public void run() {
        while (this.getRun()) {
            try {
                Thread.sleep(this.limitMilliSecond);
                if (this.state == EState.EXECUTE_RUNNING || !this.limitTimer.limitOver() && this.state != EState.COUNT_OVER) continue;
                this.chunkExecute();
            }
            catch (Exception e) {
                log.error("[se] ChunkCycleCountExecutor error so init() continue.. Exception " + e);
                this.init();
            }
        }
    }

    private void init() {
        this.state = EState.WAIT;
        this.limitTimer.initTerm();
        if (this.limitCounter == null) {
            return;
        }
        this.limitCounter.init();
    }

    public synchronized void chunkExecute() {
        try {
            this.state = EState.EXECUTE_RUNNING;
            this.executor.execute();
        }
        finally {
            this.init();
        }
    }
}

