/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.charset;

import com.humuson.tms.util.charset.LineTextExecutor;
import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.channels.FileChannel;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.io.IOUtils;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileControlUtil {
    private static final Logger log = LoggerFactory.getLogger(FileControlUtil.class);

    public String autoDetectCharsetInputStream(InputStream in) throws IOException {
        int length;
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = in.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString(FileControlUtil.detectCharset(in));
    }

    public static String readAllFileTextForSmall(String fullPathFileName) throws IOException {
        return new String(Files.readAllBytes(Paths.get(fullPathFileName, new String[0])), FileControlUtil.detectCharset(new BufferedInputStream(new FileInputStream(new File(fullPathFileName))), true));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String charsetFile(String fullPathFileName) throws Exception {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(fullPathFileName)));){
            String string = FileControlUtil.detectCharset(bis);
            return string;
        }
    }

    public static String localSystemCharset() {
        return LocalCharset.System.charset();
    }

    public static String localJvmCharset() {
        return LocalCharset.Jvm.charset();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void readLineFileController(String fullPathFileName, LineTextExecutor job) throws Exception {
        try (BufferedInputStream bis = new BufferedInputStream(new FileInputStream(new File(fullPathFileName)));){
            String charset = FileControlUtil.detectCharset(bis);
            try (BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)bis, charset));){
                String s;
                int count = 1;
                while ((s = r.readLine()) != null) {
                    try {
                        job.task(s);
                        ++count;
                    }
                    catch (Exception e) {
                        if (job.offByOneError()) throw e;
                        log.error("file[{}] lines[{}] task error", new Object[]{fullPathFileName, count, e});
                        continue;
                        return;
                    }
                }
            }
        }
    }

    public static String detectCharset(String data) {
        return FileControlUtil.detectCharset(data.getBytes());
    }

    public static String detectCharset(byte[] bytes) {
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(bytes, 0, bytes.length);
        detector.dataEnd();
        String detectedCharset = detector.getDetectedCharset();
        if (detectedCharset != null && detector.isDone() && Charset.isSupported(detectedCharset)) {
            return detectedCharset;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String detectCharset(InputStream in, boolean finallyStreamClose) throws IOException {
        CharsetDetector cd = new CharsetDetector();
        try {
            if (in instanceof FileInputStream) {
                cd.setText((InputStream)new BufferedInputStream(in));
            } else {
                cd.setText(in);
            }
            cd.setText(in);
            CharsetMatch cm = cd.detect();
            if (cm != null) {
                String string = cm.getName();
                return string;
            }
            log.warn("failed finding charset so return default[UTF-8]");
            String string = StandardCharsets.UTF_8.name();
            return string;
        }
        finally {
            if (finallyStreamClose) {
                in.close();
            }
        }
    }

    private static String detectCharset(InputStream in) throws IOException {
        return FileControlUtil.detectCharset(in, false);
    }

    public String changedToUTF8(InputStream in) {
        StringWriter writer = new StringWriter();
        try {
            String charset = FileControlUtil.detectCharset(in);
            if (!FileControlUtil.isUTF8(charset)) {
                IOUtils.copy((InputStream)in, (Writer)writer, (String)FileControlUtil.detectCharset(in));
            }
        }
        catch (Exception e) {
            log.error("charset change error so try default read", (Throwable)e);
        }
        return writer.toString();
    }

    private static boolean isUTF8(String charset) {
        return StandardCharsets.UTF_8.name().equalsIgnoreCase(charset);
    }

    private boolean identify(byte[] bytes, CharsetDecoder decoder) {
        try {
            decoder.decode(ByteBuffer.wrap(bytes));
        }
        catch (CharacterCodingException e) {
            return false;
        }
        return true;
    }

    public static void main10(String[] args) throws IOException {
        String s;
        File in = new File("E:/test/euckr.txt");
        File out = new File("E:/test/new-utf8.txt");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(in));
        BufferedReader r = new BufferedReader(new InputStreamReader(bis));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
        while ((s = r.readLine()) != null) {
            System.out.println(s);
            bos.write(s.getBytes("UTF-8"));
            bos.write("\n".getBytes());
            bos.flush();
        }
    }

    public static String convert(String str, String encoding) throws IOException {
        ByteArrayOutputStream requestOutputStream = new ByteArrayOutputStream();
        requestOutputStream.write(str.getBytes(encoding));
        return requestOutputStream.toString(encoding);
    }

    public static void readWithBuffers(File f) throws Exception {
        FileInputStream fis = new FileInputStream(f);
        FileChannel channel = fis.getChannel();
        CharsetDecoder decoder = Charset.defaultCharset().newDecoder();
        System.out.println("default charset=" + decoder.toString());
        ByteBuffer bbuf = ByteBuffer.allocate(4096);
        CharBuffer cbuf = CharBuffer.allocate(4096);
        while (true) {
            if (-1 == channel.read(bbuf)) break;
            bbuf.flip();
            CoderResult res = decoder.decode(bbuf, cbuf, false);
            if (CoderResult.OVERFLOW == res) {
                cbuf.clear();
                continue;
            }
            if (CoderResult.UNDERFLOW != res) continue;
            bbuf.compact();
        }
        decoder.decode(bbuf, cbuf, true);
        decoder.flush(cbuf);
        fis.close();
    }

    public static void main123(String[] asrgs) {
        System.out.println(FileControlUtil.localSystemCharset());
    }

    public static void maina(String[] args) throws Exception {
        LineTextExecutor executor = new LineTextExecutor(){

            @Override
            public void task(String text) throws Exception {
                System.out.println(text);
            }

            @Override
            public boolean offByOneError() {
                return false;
            }
        };
        FileControlUtil.readLineFileController("E:/test/euckr.txt", executor);
    }

    public static void main(String[] args) throws Exception {
        FileControlUtil.readWithBuffers(new File("E:/test/euckr.txt"));
    }

    public static void main7(String[] args) throws IOException {
        String s;
        File in = new File("E:/test/euckr.txt");
        File out = new File("E:/test/local-Jvm.txt");
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(in));
        CharsetDetector cd = new CharsetDetector();
        cd.setText((InputStream)bis);
        CharsetMatch cm = cd.detect();
        String charset = "";
        if (cm != null) {
            Reader reader = cm.getReader();
            charset = cm.getName();
            System.out.println(cm.getName());
        }
        BufferedReader r = new BufferedReader(new InputStreamReader((InputStream)bis, charset));
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(out));
        while ((s = r.readLine()) != null) {
            System.out.println(s);
            bos.write(s.getBytes(FileControlUtil.localSystemCharset()));
            bos.write("\n".getBytes());
            bos.flush();
        }
    }

    public Charset detectCharset(File f, String[] charsets) {
        String charsetName;
        Charset charset = null;
        String[] stringArray = charsets;
        int n = stringArray.length;
        for (int i = 0; i < n && (charset = this.detectCharset(f, Charset.forName(charsetName = stringArray[i]))) == null; ++i) {
        }
        return charset;
    }

    private Charset detectCharset(File f, Charset charset) {
        try {
            BufferedInputStream input = new BufferedInputStream(new FileInputStream(f));
            CharsetDecoder decoder = charset.newDecoder();
            decoder.reset();
            byte[] buffer = new byte[512];
            boolean identified = false;
            while (input.read(buffer) != -1 && !identified) {
                identified = this.identify(buffer, decoder);
            }
            input.close();
            if (identified) {
                return charset;
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    static enum LocalCharset {
        System,
        Jvm;

        private final String charset = this.name().equals("System") ? java.lang.System.getProperty("sun.jnu.encoding") : Charset.defaultCharset().toString();

        public String charset() {
            return this.charset;
        }
    }
}

