/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util.charset;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;

public class EncodingTest {
    public static void main1(String[] args) {
        System.out.println(String.format("file.encoding: %s", System.getProperty("file.encoding")));
        System.out.println(String.format("defaultCharset: %s", Charset.defaultCharset().name()));
    }

    public static void main(String[] args) throws UnsupportedEncodingException {
        String character = "A";
        byte[] sourceBytes = character.getBytes("UTF-8");
        String strBytes = EncodingTest.byteArrayToHex(sourceBytes);
        System.out.print("UTF-8:");
        System.out.println(strBytes);
        sourceBytes = character.getBytes("EUC-KR");
        strBytes = EncodingTest.byteArrayToHex(sourceBytes);
        System.out.print("EUC-KR:");
        System.out.println(strBytes);
        sourceBytes = character.getBytes("UTF-16");
        strBytes = EncodingTest.byteArrayToHex(sourceBytes);
        System.out.print("UTF-16:");
        System.out.println(strBytes);
        sourceBytes = character.getBytes("CP949");
        strBytes = EncodingTest.byteArrayToHex(sourceBytes);
        System.out.print("CP949:");
        System.out.println(strBytes);
        sourceBytes = character.getBytes("ASCII");
        strBytes = EncodingTest.byteArrayToHex(sourceBytes);
        System.out.print("ASCII:");
        System.out.println(strBytes);
        System.out.println();
        character = "\ud55c\uae00";
        sourceBytes = character.getBytes("UTF-8");
        strBytes = EncodingTest.byteArrayToHex(sourceBytes);
        System.out.print("UTF-8:");
        System.out.println(strBytes);
        System.out.println(new String(sourceBytes, "UTF-8"));
        String test = new String(character.getBytes("EUC-KR"), "EUC-KR");
        strBytes = EncodingTest.byteArrayToHex(test.getBytes());
        System.out.print("EUC-KR:");
        System.out.println(strBytes);
        System.out.println(new String(test.getBytes("UTF-8"), "UTF-8"));
        sourceBytes = character.getBytes("UTF-16");
        strBytes = EncodingTest.byteArrayToHex(sourceBytes);
        System.out.print("UTF-16:");
        System.out.println(strBytes);
        sourceBytes = character.getBytes("CP949");
        strBytes = EncodingTest.byteArrayToHex(sourceBytes);
        System.out.print("CP949:");
        System.out.println(strBytes);
        sourceBytes = character.getBytes("ASCII");
        strBytes = EncodingTest.byteArrayToHex(sourceBytes);
        System.out.print("ASCII:");
        System.out.println(strBytes);
    }

    public static String byteArrayToHex(byte[] a) {
        StringBuilder sb = new StringBuilder();
        for (byte b : a) {
            sb.append(String.format("%02x ", b & 0xFF));
        }
        return sb.toString();
    }
}

