/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import org.springframework.core.annotation.AnnotationUtils;

public class TmsAnnotationUtil
extends AnnotationUtils {
    public static Annotation findOneAnnotation(Annotation[] annotation, Class<? extends Annotation> annotationType) {
        for (Annotation anno : annotation) {
            if (!TmsAnnotationUtil.isAnnotationPresent(anno, annotationType)) continue;
            return anno;
        }
        return null;
    }

    public static Annotation findAnnotation(Annotation annotation, Class<? extends Annotation> annotationType) {
        if (annotation.annotationType().equals(annotationType)) {
            return annotation;
        }
        for (Annotation anno : annotation.annotationType().getDeclaredAnnotations()) {
            if (!anno.annotationType().equals(annotationType)) continue;
            return anno;
        }
        return null;
    }

    public static boolean isAnnotationPresent(Annotation annotation, Class<? extends Annotation> annotationType) {
        return TmsAnnotationUtil.findAnnotation(annotation, annotationType) != null;
    }

    public static boolean isAnnotationPresent(Field field, Class<? extends Annotation> annotationType) {
        for (Annotation anno : field.getDeclaredAnnotations()) {
            if (!TmsAnnotationUtil.isAnnotationPresent(anno, annotationType)) continue;
            return true;
        }
        return false;
    }

    public static Annotation[] findAnnotations(Field field, Class<? extends Annotation>[] annotationTypes) {
        ArrayList<Annotation> list = new ArrayList<Annotation>();
        for (Annotation anno : field.getDeclaredAnnotations()) {
            for (Class<? extends Annotation> type : annotationTypes) {
                Annotation a = TmsAnnotationUtil.findAnnotation(anno, type);
                if (a == null) continue;
                list.add(a);
            }
        }
        return list.toArray(new Annotation[0]);
    }

    public static boolean isAnnotationPresent(Field field, Class<? extends Annotation>[] annotationTypes) {
        for (Annotation anno : field.getDeclaredAnnotations()) {
            for (Class<? extends Annotation> type : annotationTypes) {
                Annotation a = TmsAnnotationUtil.findAnnotation(anno, type);
                if (a == null) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotationPresent(Annotation[] annotations, Class<? extends Annotation> annotationType) {
        for (Annotation annotation : annotations) {
            if (!TmsAnnotationUtil.isAnnotationPresent(annotation, annotationType)) continue;
            return true;
        }
        return false;
    }
}

