/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util;

import com.humuson.tms.util.CustomTimestampEditor;
import java.beans.PropertyEditor;
import java.lang.reflect.Field;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.propertyeditors.CustomBooleanEditor;
import org.springframework.beans.propertyeditors.CustomDateEditor;
import org.springframework.core.MethodParameter;
import org.springframework.core.NamedThreadLocal;

public class ThreadSafedSimpleTypeConverter
implements TypeConverter {
    private final ThreadLocal<SimpleTypeConverter> simpleTypeConverters = new NamedThreadLocal<SimpleTypeConverter>("ThreadSafedSimpleTypeConverter_Converters"){

        protected SimpleTypeConverter initialValue() {
            return ThreadSafedSimpleTypeConverter.this.createSimpleTypeConverter();
        }
    };

    public <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        return (T)this.simpleTypeConverters.get().convertIfNecessary(value, requiredType);
    }

    public <T> T convertIfNecessary(Object value, Class<T> requiredType, MethodParameter methodParam) throws TypeMismatchException {
        return (T)this.simpleTypeConverters.get().convertIfNecessary(value, requiredType, methodParam);
    }

    public <T> T convertIfNecessary(Object value, Class<T> requiredType, Field field) throws TypeMismatchException {
        return (T)this.simpleTypeConverters.get().convertIfNecessary(value, requiredType, field);
    }

    public SimpleTypeConverter getSimpleTypeConverter() {
        return this.simpleTypeConverters.get();
    }

    protected SimpleTypeConverter createSimpleTypeConverter() {
        SimpleTypeConverter simpleTypeConverter = new SimpleTypeConverter();
        simpleTypeConverter.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()), true));
        simpleTypeConverter.registerCustomEditor(Timestamp.class, (PropertyEditor)new CustomTimestampEditor(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault()), true));
        simpleTypeConverter.registerCustomEditor(Boolean.TYPE, (PropertyEditor)new CustomBooleanEditor(false));
        simpleTypeConverter.registerCustomEditor(Boolean.class, (PropertyEditor)new CustomBooleanEditor(true));
        return simpleTypeConverter;
    }
}

