/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShowObject {
    private static final Logger log = LoggerFactory.getLogger(ShowObject.class);

    public static void show(Object obj) {
        ShowObject.show(obj, false);
    }

    public static void show(Object obj, boolean showType) {
        if (obj instanceof Map) {
            ShowObject.showMap((Map)obj, 0, showType);
        } else if (obj instanceof List) {
            ShowObject.showList((List)obj, 0, showType);
        } else if (showType) {
            log.debug("(" + ShowObject.getType(obj) + ")" + obj);
        } else {
            log.debug("{}", obj);
        }
    }

    private static void showMap(Map map, int dept, boolean showType) {
        for (Object key : map.keySet()) {
            Object val = map.get(key);
            if (val instanceof Map) {
                ShowObject.showMap((Map)val, dept + 1, showType);
                continue;
            }
            if (val instanceof List) {
                ShowObject.showList((List)val, dept + 1, showType);
                continue;
            }
            log.debug(ShowObject.getObjStr(val, key, showType));
        }
    }

    private static void showList(List list, int dept, boolean showType) {
        for (Object obj : list) {
            if (obj instanceof Map) {
                ShowObject.showMap((Map)obj, dept + 1, showType);
                continue;
            }
            if (obj instanceof List) {
                ShowObject.showList((List)obj, dept + 1, showType);
                continue;
            }
            log.debug(ShowObject.getObjStr(obj, null, showType));
        }
    }

    public static <T> void showBean(String header, T bean) {
        log.debug(header);
        ShowObject.showBean(bean);
    }

    public static void show2(String header, Object obj) {
        log.debug(header);
        ShowObject.show2(obj);
    }

    public static <T> void showBean(T bean) {
        Class<?> cls = bean.getClass();
        Method[] methods = cls.getDeclaredMethods();
        for (int i = 0; i < methods.length; ++i) {
            if (methods[i].getName().indexOf("get") != 0) continue;
            try {
                log.debug(methods[i].getName() + " : " + methods[i].invoke(bean, new Object[0]));
                continue;
            }
            catch (IllegalArgumentException e) {
                log.error("IllegalArgumentException", (Throwable)e);
                continue;
            }
            catch (IllegalAccessException e) {
                log.error("IllegalAccessException", (Throwable)e);
                continue;
            }
            catch (InvocationTargetException e) {
                log.error("InvocationTargetException", (Throwable)e);
            }
        }
    }

    public static void show2(Object obj) {
        ToStringStyle style = ToStringStyle.MULTI_LINE_STYLE;
        ReflectionToStringBuilder tsb = new ReflectionToStringBuilder(obj, style);
        log.debug(tsb.toString());
    }

    private static String getType(Object obj) {
        return obj.getClass().getSimpleName();
    }

    private static int getCode(Object[] array) {
        StringBuffer codeBuffer = new StringBuffer();
        int j = array.length;
        for (int i = 0; i < j; ++i) {
            if (array[i] != null) {
                codeBuffer.append("1");
                continue;
            }
            codeBuffer.append("0");
        }
        return Integer.parseInt(codeBuffer.toString());
    }

    private static String makeObjShowStr(Object ... obj) {
        switch (ShowObject.getCode(obj)) {
            case 100: {
                return String.format(" %10s ", obj[0]);
            }
            case 101: {
                return String.format(" (%5s)%10s ", obj[2], obj[0]);
            }
            case 110: {
                return String.format(" [%5s : %10s] ", obj[1], obj[0]);
            }
            case 111: {
                return String.format(" [%5s : (%5s)%10s] ", obj[1], obj[2], obj[0]);
            }
        }
        return null;
    }

    private static String getObjStr(Object value, Object key, boolean showType) {
        return ShowObject.makeObjShowStr(value, key, showType ? ShowObject.getType(value) : null);
    }
}

