/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util;

import java.io.File;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PackageUtil {
    private static final Logger log = LoggerFactory.getLogger(PackageUtil.class);

    private static Set<Class> getClassesInPackage(String packageName) {
        HashSet<Class> classes = new HashSet<Class>();
        String packageNameSlashed = "/" + packageName.replace(".", "/");
        URL directoryURL = Thread.currentThread().getContextClassLoader().getResource(packageNameSlashed);
        if (directoryURL == null) {
            log.warn("Could not retrieve URL resource: " + packageNameSlashed);
            return classes;
        }
        String directoryString = directoryURL.getFile();
        if (directoryString == null) {
            log.warn("Could not find directory for URL resource: " + packageNameSlashed);
            return classes;
        }
        File directory = new File(directoryString);
        if (directory.exists()) {
            String[] files;
            for (String fileName : files = directory.list()) {
                if (!fileName.endsWith(".class")) continue;
                fileName = fileName.substring(0, fileName.length() - 6);
                try {
                    classes.add(Class.forName(packageName + "." + fileName));
                }
                catch (ClassNotFoundException e) {
                    log.warn(packageName + "." + fileName + " does not appear to be a valid class.", (Throwable)e);
                }
            }
        } else {
            log.warn(packageName + " does not appear to exist as a valid package on the file system.");
        }
        return classes;
    }
}

