/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObjectUtil {
    private static final Logger log = LoggerFactory.getLogger(ObjectUtil.class);

    public static <T> void objectMerge(T t, Object ... objects) throws Exception {
        for (Object o : objects) {
            try {
                BeanUtils.copyProperties(t, (Object)o);
            }
            catch (IllegalAccessException e) {
                log.error("object copy dest[{}], org[{}] error ", new Object[]{t.getClass().getName(), o.getClass().getName(), e});
                throw e;
            }
            catch (InvocationTargetException e) {
                log.error("object copy dest[{}], org[{}] error ", new Object[]{t.getClass().getName(), o.getClass().getName(), e});
                throw e;
            }
        }
    }

    public static <T> T mapToBean(Class<T> resultType, Map<String, Object> map) {
        try {
            T t = resultType.newInstance();
            BeanUtils.populate(t, map);
            return t;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            log.error("map[{}] to bean[{}] change error. next continue..", map, (Object)resultType.getName());
            return null;
        }
        catch (InstantiationException e) {
            log.error("create new Instance error. \nmap[{}] to bean[{}] next continue..", map, (Object)resultType.getName());
            e.printStackTrace();
            return null;
        }
    }

    public static void beanToMap(Map<Object, Object> map, Object obj) {
        try {
            Method[] methods;
            Class<?> pomclass = obj.getClass();
            pomclass = obj.getClass();
            for (Method m : methods = obj.getClass().getMethods()) {
                Object value;
                if (m.getName().startsWith("get") && !m.getName().startsWith("getClass")) {
                    value = m.invoke(obj, new Object[0]);
                    map.put(m.getName().substring(3), value);
                    continue;
                }
                if (!m.getName().startsWith("is") || m.getName().startsWith("getClass")) continue;
                value = m.invoke(obj, new Object[0]);
                map.put(m.getName().substring(2), value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            log.error("error bean[{}] to map change. return null", obj, (Object)e);
        }
        if (map.isEmpty()) {
            log.error("failed convert object[{}] to map, map is empty", obj);
        }
    }
}

