/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MaskingUtil {
    private static final String EMAIL_PATTERN = "^[a-z0-9A-Z._-]*@[a-z0-9A-Z]*.[a-zA-Z.]*$";
    private static final String PHONE_PATTERN = "(01[016789])(\\d{3,4})(\\d{4})";
    private static final int EMAIL_MASKING_MAX = 3;
    private static final int PHONE_MASKING_GROUP = 3;

    public static String getMaskedStr(String str) {
        if (MaskingUtil.isEmail(str)) {
            return MaskingUtil.maskingEamil(str);
        }
        if (MaskingUtil.isPhoneNum(str)) {
            return MaskingUtil.maskingPhoneNum(str);
        }
        return str;
    }

    public static String getMaskedEmailStr(String str) {
        if (MaskingUtil.isEmail(str)) {
            return MaskingUtil.maskingEamil(str);
        }
        return str;
    }

    public static String getMaskedPhoneNumStr(String str) {
        if (MaskingUtil.isPhoneNum(str)) {
            return MaskingUtil.maskingPhoneNum(str);
        }
        return str;
    }

    public static boolean isEmail(String str) {
        return MaskingUtil.isValid(EMAIL_PATTERN, str);
    }

    public static boolean isPhoneNum(String str) {
        return MaskingUtil.isValid(PHONE_PATTERN, str);
    }

    private static boolean isValid(String regex, String str) {
        Matcher matcher = Pattern.compile(regex).matcher(str);
        return matcher.matches();
    }

    private static String maskingEamil(String str) {
        String regex = "\\b(\\S+)+@(\\S+.\\S+)";
        Matcher matcher = Pattern.compile(regex).matcher(str);
        if (matcher.find()) {
            String notAt = "";
            String asterisk = "";
            String id = matcher.group(1);
            int length = id.length();
            if (length < 3) {
                char[] c = new char[length];
                Arrays.fill(c, '*');
                return str.replace(id, String.valueOf(c));
            }
            if (length == 3) {
                for (int i = 0; i < 2; ++i) {
                    notAt = notAt + "[^@]";
                    asterisk = asterisk + "*";
                }
                return str.replaceAll("\\b(\\S+)" + notAt + "+@(\\S+)", "$1" + asterisk + "@$2");
            }
            for (int i = 0; i < 3; ++i) {
                notAt = notAt + "[^@]";
                asterisk = asterisk + "*";
            }
            return str.replaceAll("\\b(\\S+)" + notAt + "+@(\\S+)", "$1" + asterisk + "@$2");
        }
        return str;
    }

    private static String maskingPhoneNum(String str) {
        String regex = "(01[016789])(\\d{3,4})(\\d{4})$";
        Matcher matcher = Pattern.compile(regex).matcher(str);
        if (matcher.find()) {
            String replaceGroup = matcher.group(3);
            char[] c = new char[replaceGroup.length()];
            Arrays.fill(c, '*');
            return str.replace(replaceGroup, String.valueOf(c));
        }
        return str;
    }

    public static void main(String[] args) {
        String email = "hwang1018kr@humuson.com";
        String phoneNum = "01012345678";
        String maskedEmail = MaskingUtil.getMaskedEmailStr(email);
        String maskedPhoneNum = MaskingUtil.getMaskedPhoneNumStr(phoneNum);
        System.out.println("masked email\t\t: " + maskedEmail);
        System.out.println("masked phone number\t: " + maskedPhoneNum);
    }
}

