/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.google.gson.JsonParseException;
import com.humuson.tms.util.StringUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class JsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JsonUtil.class);

    public Map<String, String> getMapFromTList(org.json.JSONObject jsonTList, org.json.JSONObject jsonDHead) throws Exception {
        HashMap<String, String> mapData = new HashMap<String, String>();
        if (jsonTList.length() != jsonDHead.length()) {
            return null;
        }
        Iterator iterator = jsonDHead.keys();
        while (iterator.hasNext()) {
            String dHeadKey = (String)iterator.next();
            String dHeadValue = jsonDHead.get(dHeadKey).toString();
            mapData.put(dHeadKey, jsonDHead.getString(dHeadValue));
        }
        return mapData;
    }

    public org.json.JSONObject makeDHeadJson(Map<String, String> sampleTarget) throws Exception {
        org.json.JSONObject json = new org.json.JSONObject();
        Set<String> keyList = sampleTarget.keySet();
        int i = 0;
        for (String key : keyList) {
            json.put(key, ++i);
        }
        return json;
    }

    public org.json.JSONObject makeTListMap(Map<String, String> sampleTarget, String dHead, String useCrypto) throws Exception {
        if (dHead != null && !dHead.isEmpty() && dHead.contains("{")) {
            return this.makeTListMap(sampleTarget, new org.json.JSONObject(dHead), useCrypto);
        }
        return this.makeTListMap(sampleTarget, new org.json.JSONObject(), useCrypto);
    }

    public org.json.JSONObject makeTListMap(Map<String, String> sampleTarget, org.json.JSONObject jsonDHead, String useCrypto) throws Exception {
        org.json.JSONObject jsonTarget = new org.json.JSONObject();
        if (jsonDHead.length() > 0) {
            if (sampleTarget.size() != jsonDHead.length()) {
                return null;
            }
            Iterator iterator = jsonDHead.keys();
            while (iterator.hasNext()) {
                String stringKey = (String)iterator.next();
                String newIntKey = jsonDHead.get(stringKey).toString();
                jsonTarget.put(newIntKey, (Object)sampleTarget.get(stringKey));
            }
        } else {
            for (Map.Entry<String, String> elem : sampleTarget.entrySet()) {
                jsonTarget.put(elem.getKey(), (Object)elem.getValue());
            }
        }
        return jsonTarget;
    }

    public Map<String, String> getMapFromTList(String tList, String dHead) throws Exception {
        return this.getMapFromTList(new org.json.JSONObject(tList), new org.json.JSONObject(dHead));
    }

    public static Map<String, String> getMapFromJson(String value) {
        if (StringUtils.isEmpty((CharSequence)value)) {
            throw new NullPointerException();
        }
        Map<String, String> resultMap = new HashMap<String, String>();
        JSONParser parser = new JSONParser();
        JSONObject jsonObj = null;
        try {
            Object obj = parser.parse(value);
            jsonObj = (JSONObject)obj;
            resultMap = (Map)new ObjectMapper().readValue(jsonObj.toJSONString(), Map.class);
        }
        catch (JsonParseException e) {
            log.error("[JsonUtil] {}", (Object)value);
            e.printStackTrace();
        }
        catch (JsonMappingException e) {
            log.error("[JsonUtil] {}", (Object)value);
            e.printStackTrace();
        }
        catch (ParseException e) {
            log.error("[JsonUtil] {}", (Object)value);
            e.printStackTrace();
        }
        catch (IOException e) {
            log.error("[JsonUtil] {}", (Object)value);
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            log.error(" Json to Map data is null ");
        }
        return resultMap;
    }

    public static String convertMapToJsonString(Map<String, Object> map, List<String> deleteKeys) throws IOException, Exception {
        for (String key : deleteKeys) {
            map.remove(key);
        }
        return JsonUtil.convertMapToJsonString(map);
    }

    public static String convertMapToJsonStringAddNull(Map<String, Object> map) throws IOException, Exception {
        return JsonUtil.convertMapToJsonString(map, true);
    }

    public static String convertMapToJsonString(Map<String, Object> map) throws IOException, Exception {
        return JsonUtil.convertMapToJsonString(map, true);
    }

    public static void overWriteNullToEmpty(org.json.JSONObject json) throws JSONException {
        Iterator iter = json.keys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!json.isNull(key)) continue;
            json.put(key, (Object)"");
        }
    }

    public static String mapToJsonStringNullToEmpty(ObjectMapper mapper, Map<String, Object> map) throws JsonProcessingException {
        mapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object value, JsonGenerator gen, SerializerProvider serializers) throws IOException, JsonProcessingException {
                gen.writeString("");
            }
        });
        return mapper.writeValueAsString(map);
    }

    public static String convertMapToJsonString(Map<String, Object> map, boolean addWriteNull) throws IOException, Exception {
        try {
            ObjectMapper jsonMapper = new ObjectMapper();
            jsonMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, addWriteNull);
            String jsonMappered = jsonMapper.writeValueAsString(map);
            if (log.isDebugEnabled()) {
                log.debug("map[{}] to json mapper string {}", map, (Object)jsonMappered);
            }
            return jsonMappered;
        }
        catch (IOException ie) {
            log.error("map to json string error map[{}]", map);
            throw ie;
        }
        catch (Exception e) {
            log.error("map to json string error map[{}]", map);
            throw e;
        }
    }

    public static String convertStringMapToJsonString(Map<String, String> map, boolean addWriteNull) throws IOException, Exception {
        try {
            ObjectMapper jsonMapper = new ObjectMapper();
            jsonMapper.configure(SerializationFeature.WRITE_NULL_MAP_VALUES, addWriteNull);
            String jsonMappered = jsonMapper.writeValueAsString(map);
            if (log.isDebugEnabled()) {
                log.debug("map[{}] to json mapper string {}", map, (Object)jsonMappered);
            }
            return jsonMappered;
        }
        catch (IOException ie) {
            log.error("map to json string error map[{}]", map);
            throw ie;
        }
        catch (Exception e) {
            log.error("map to json string error map[{}]", map);
            throw e;
        }
    }

    public static void main(String[] args) throws Exception {
        Object dataNull = null;
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("DATA_NULL", dataNull);
        map.put("EMPTY", "");
        map.put("DATA", "data");
        map.put("Integer=10", Integer.getInteger("10"));
        map.put("Int", 5);
        map.put("Int0", 0);
        String result = JsonUtil.mapToJsonStringNullToEmpty(new ObjectMapper(), map);
        org.json.JSONObject jObject = new org.json.JSONObject(map);
        JsonUtil.overWriteNullToEmpty(jObject);
        System.out.println("RESULT=" + jObject.toString());
    }
}

