/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.regex.Pattern;

public class FileUtil {
    public static boolean isValidFile(String fileName) {
        boolean valid = true;
        File file = new File(fileName);
        if (!file.exists() || file.isDirectory()) {
            valid = false;
        }
        return valid;
    }

    public static boolean moveFile(String fileName, String toFileName, String fileDirPath, String destDirPath) {
        File file = new File(fileDirPath + "/" + fileName);
        return file.renameTo(new File(destDirPath + "/" + toFileName));
    }

    public static boolean moveFile(String fileName, String fileDirPath, String destDirPath) {
        File file = new File(fileDirPath + "/" + fileName);
        return file.renameTo(new File(destDirPath + "/" + fileName));
    }

    public static void copyFile(String fileName, String fileDirPath, String destDirPath) {
        FileUtil.copyFile(fileName, fileName, fileDirPath, destDirPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(String fileName, String toFileName, String fileDirPath, String destDirPath) {
        FileInputStream fis = null;
        FileOutputStream fos = null;
        AbstractInterruptibleChannel fcIn = null;
        AbstractInterruptibleChannel fcOut = null;
        try {
            File sourceFile = new File(fileDirPath + "/" + fileName);
            File destFile = new File(destDirPath + "/" + fileName);
            fis = new FileInputStream(sourceFile);
            fos = new FileOutputStream(destFile);
            fcIn = fis.getChannel();
            fcOut = fos.getChannel();
            long size = ((FileChannel)fcIn).size();
            ((FileChannel)fcIn).transferTo(0L, size, (WritableByteChannel)((Object)fcOut));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (fcIn != null) {
                try {
                    fcIn.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fcOut != null) {
                try {
                    fcOut.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrl(String url) throws IOException {
        HttpURLConnection m_client;
        if (url == null) {
            return null;
        }
        URL myURL = new URL(url.trim());
        int __RESPONSE_CODE__ = 0;
        try {
            m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = m_client.getResponseCode();
        }
        catch (Exception ignore) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = m_client.getResponseCode();
        }
        switch (__RESPONSE_CODE__) {
            case 403: {
                throw new IOException("HTTP Status-Code 403: Forbidden.=>".concat(url));
            }
            case 500: {
                throw new IOException("HTTP Status-Code 500: Internal Server Error.=>".concat(url));
            }
            case 406: {
                throw new IOException("HTTP Status-Code 406: Not Acceptable.=>".concat(url));
            }
            case 404: {
                throw new IOException("HTTP Status-Code 404: Not Found.=>".concat(url));
            }
            case 503: {
                throw new IOException("HTTP Status-Code 503: Service Unavailable.=>".concat(url));
            }
            case 200: {
                break;
            }
            default: {
                throw new IOException(m_client.getResponseMessage().concat("=>").concat(url));
            }
        }
        InputStream is = m_client.getInputStream();
        byte[] b = new byte[128];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int j;
            while ((j = is.read(b)) > 0) {
                baos.write(b, 0, j);
            }
            String string = baos.toString("UTF-8");
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
            if (m_client != null) {
                try {
                    m_client.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readUrl(String url, String charset) throws IOException {
        HttpURLConnection m_client;
        if (url == null) {
            return null;
        }
        url = url.trim();
        URL myURL = new URL(url);
        int __RESPONSE_CODE__ = 0;
        try {
            m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = m_client.getResponseCode();
        }
        catch (Exception ignore) {
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            m_client = (HttpURLConnection)myURL.openConnection();
            __RESPONSE_CODE__ = m_client.getResponseCode();
        }
        switch (__RESPONSE_CODE__) {
            case 403: {
                throw new IOException("HTTP Status-Code 403: Forbidden.=>".concat(url));
            }
            case 500: {
                throw new IOException("HTTP Status-Code 500: Internal Server Error.=>".concat(url));
            }
            case 406: {
                throw new IOException("HTTP Status-Code 406: Not Acceptable.=>".concat(url));
            }
            case 404: {
                throw new IOException("HTTP Status-Code 404: Not Found.=>".concat(url));
            }
            case 503: {
                throw new IOException("HTTP Status-Code 503: Service Unavailable.=>".concat(url));
            }
            case 200: {
                break;
            }
            default: {
                throw new IOException(m_client.getResponseMessage().concat("=>").concat(url));
            }
        }
        InputStream is = m_client.getInputStream();
        byte[] b = new byte[128];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int j;
            while ((j = is.read(b)) > 0) {
                baos.write(b, 0, j);
            }
            String string = baos.toString(charset);
            return string;
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception exception) {}
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
            if (m_client != null) {
                try {
                    m_client.disconnect();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean mkDirs(String directoryName) {
        boolean ret = false;
        File theDir = new File(directoryName);
        if (!theDir.exists()) {
            try {
                theDir.mkdirs();
                ret = true;
            }
            catch (SecurityException e) {
                e.printStackTrace();
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getLocalResource(String theName) {
        try {
            StringBuilder buf = new StringBuilder(3000);
            try (BufferedInputStream is = new BufferedInputStream(new FileInputStream(new File(theName)));){
                int i;
                while ((i = is.read()) != -1) {
                    buf.append((char)i);
                }
            }
            String resource = buf.toString();
            String[] lines = resource.split("\\r?\\n");
            StringBuilder buffer = new StringBuilder();
            for (int j = 0; j < lines.length; ++j) {
                buffer.append(lines[j]);
                buffer.append("\n");
            }
            return buffer.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static String lastSeparator(String dir) {
        if (dir.endsWith(File.separator) || dir.endsWith("/")) {
            return dir;
        }
        return dir + File.separator;
    }

    public static byte[] getApnsFile(String file) throws Exception {
        File test = new File(file);
        byte[] byteCertFile = new byte[(int)test.length()];
        FileInputStream io = null;
        io = new FileInputStream(test);
        io.read(byteCertFile);
        io.close();
        return byteCertFile;
    }

    public static String readFile(String fileName) throws IOException, FileNotFoundException {
        BufferedReader reader = null;
        StringBuilder stringBuilder = new StringBuilder();
        char[] buffer = new char[10];
        try {
            reader = new BufferedReader(new FileReader(fileName));
            while (reader.read(buffer) != -1) {
                stringBuilder.append(new String(buffer));
                buffer = new char[10];
            }
        }
        catch (FileNotFoundException e) {
            throw new FileNotFoundException("[" + fileName + "]this Content File is not found ");
        }
        catch (IOException e) {
            throw new IOException("[" + fileName + "]this Content File");
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e2) {
                    throw new IOException("Close content reader error");
                }
            }
        }
        return stringBuilder.toString();
    }

    public static String readLocal(String fName, String enc) throws IOException {
        File f = new File(fName);
        return FileUtil.readLocal(f, enc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readLocal(File f, String enc) throws IOException {
        FileInputStream fis = new FileInputStream(f);
        byte[] b = new byte[128];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int j;
            while ((j = fis.read(b)) > 0) {
                baos.write(b, 0, j);
            }
            String string = baos.toString(enc);
            return string;
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static boolean detectFilePattern(String pattern, String value) {
        return Pattern.compile(pattern).matcher(value).find();
    }

    public static String getLastLineFast(File file) {
        if (!file.exists() || file.isDirectory()) {
            return "";
        }
        if (file.length() <= 2L) {
            return "";
        }
        try {
            long blockStart;
            RandomAccessFile fileAccess = new RandomAccessFile(file, "r");
            byte breakLine = 10;
            byte[] currentBlock = new byte[(int)(file.length() - blockStart)];
            ArrayList<byte[]> laterBlocks = new ArrayList<byte[]>();
            for (blockStart = (file.length() - 1L) / 4096L * 4096L; blockStart >= 0L; blockStart -= 4096L) {
                fileAccess.seek(blockStart);
                fileAccess.readFully(currentBlock);
                int lengthToScan = currentBlock.length - (laterBlocks.isEmpty() ? 2 : 0);
                for (int i = lengthToScan - 1; i >= 0; --i) {
                    if (currentBlock[i] != breakLine) continue;
                    StringBuilder result = new StringBuilder();
                    result.append(new String(currentBlock, i + 1, currentBlock.length - (i + 1), "ISO-8859-1"));
                    for (byte[] laterBlock : laterBlocks) {
                        result.append(new String(laterBlock, "ISO-8859-1"));
                    }
                    if (result.charAt(result.length() - 1) == breakLine) {
                        int newlineLength = result.charAt(result.length() - 2) == '\r' ? 2 : 1;
                        result.setLength(result.length() - newlineLength);
                    }
                    return result.toString();
                }
                laterBlocks.add(0, currentBlock);
                currentBlock = new byte[4096];
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return "";
    }
}

