/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util;

import org.apache.commons.io.FilenameUtils;
import org.springframework.stereotype.Component;

@Component
public class FileExtentionUtil {
    public final String[] RESTRICTED_EXTENTIONS = new String[]{"jsp", "asp", "cgi", "php", "php3", "inc", "pl"};
    public final String[] IMAGE_FILE_EXTENTIONS = new String[]{"gif", "png", "jpg", "jpeg"};
    public final String[] TARGETING_FILE_EXTENTIONS = new String[]{"txt", "csv", "xls", "xlsx"};
    public final String[] P12_FILE_EXTENTIONS = new String[]{"p12"};

    public boolean isValidExtention(String fileName) {
        return !FilenameUtils.isExtension((String)(fileName = fileName.toLowerCase()), (String[])this.RESTRICTED_EXTENTIONS);
    }

    public boolean isImageFileExtention(String fileName) {
        if (this.isValidExtention(fileName = fileName.toLowerCase())) {
            return FilenameUtils.isExtension((String)fileName, (String[])this.IMAGE_FILE_EXTENTIONS);
        }
        return false;
    }

    public boolean isTargetingFileExtention(String fileName) {
        if (this.isValidExtention(fileName = fileName.toLowerCase())) {
            return FilenameUtils.isExtension((String)fileName, (String[])this.TARGETING_FILE_EXTENTIONS);
        }
        return false;
    }

    public boolean isP12FileExtention(String fileName) {
        if (this.isValidExtention(fileName = fileName.toLowerCase())) {
            return FilenameUtils.isExtension((String)fileName, (String[])this.P12_FILE_EXTENTIONS);
        }
        return false;
    }
}

