/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.util;

import com.humuson.tms.util.ThreadSafedSimpleTypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.TypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.util.ClassUtils;

public class ConvertUtils {
    private static final Logger log = LoggerFactory.getLogger(ConvertUtils.class);
    private static final TypeConverter SIMPLE_TYPE_CONVERTER = new ThreadSafedSimpleTypeConverter();

    public static <T> T convertIfNecessary(Object value, Class<T> requiredType) throws TypeMismatchException {
        try {
            return (T)SIMPLE_TYPE_CONVERTER.convertIfNecessary(value, requiredType);
        }
        catch (RuntimeException e) {
            log.error("Fail convert type. value:[" + value.toString() + "}, type:[" + ClassUtils.getQualifiedName(requiredType) + "]", (Throwable)e);
            throw e;
        }
    }
}

