/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.schedule;

import com.humuson.tms.adaptor.redis.WrapperRedisTemplate;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.config.lock.LockContexter;
import com.humuson.tms.config.lock.LockController;
import com.humuson.tms.monitor.AbstractCommonMonitorNotification;
import com.humuson.tms.monitor.ProgressStatusEventer;
import com.humuson.tms.monitor.ProgressStatusInfo;
import com.humuson.tms.util.CheckerPossibleOfChain;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.ObjectUtils;

public class TmsMonitorStatusScheduler {
    private static final Logger log = LoggerFactory.getLogger(TmsMonitorStatusScheduler.class);
    private CheckerPossibleOfChain<ProgressStatusEventer> firstEmpty = new CheckerPossibleOfChain<ProgressStatusEventer>(){

        @Override
        protected boolean isSuccess(ProgressStatusEventer t) {
            return true;
        }

        @Override
        protected String getImpassableMessage() {
            return "is Empty";
        }
    };
    @Autowired
    WrapperRedisTemplate redis;
    @Autowired
    AbstractCommonMonitorNotification notification;
    @Autowired
    ProgressStatusEventer progressEventer;
    private static String ENGINE_NODE;
    @Autowired
    private TmsCommonConfig config;
    @Autowired
    private LockContexter contexter;
    LockController lock = null;

    @PostConstruct
    public void init() {
        ENGINE_NODE = this.config.getEngine() + this.config.getNode();
        this.notification.add(this.firstEmpty);
        this.lockChecking();
    }

    @Scheduled(fixedDelay=60000L)
    public void statusRegist() throws Exception {
        this.lockChecking();
        if (!this.isDangerousCondition()) {
            return;
        }
        String message = this.firstEmpty.impassableMessage();
        log.warn(message);
        ProgressStatusInfo nowStatus = this.progressEventer.progressStatusInfo();
        nowStatus.setMessage(message);
        ProgressStatusInfo oldStatus = this.redis.getJsonToObject(this.makeKey(), nowStatus.getEvent().name(), ProgressStatusInfo.class);
        if (!ObjectUtils.isEmpty((Object)oldStatus)) {
            return;
        }
        this.redis.putObjectToJson(this.makeKey(), nowStatus.getEvent().name(), nowStatus);
    }

    private void lockChecking() {
        if (this.lock == null) {
            this.lock = this.contexter.lock(ENGINE_NODE);
            this.lock.lock();
        } else if (!this.lock.isLocked()) {
            this.lock.lock();
        }
    }

    private String makeKey() {
        return "JSTAT:" + ENGINE_NODE;
    }

    private boolean isDangerousCondition() {
        return !this.firstEmpty.passableRegist(this.progressEventer);
    }
}

