/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.schedule;

import com.humuson.tms.adaptor.jdbc.TmsBatchDataSourceManager;
import com.humuson.tms.util.date.DateUtil;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TmsDataSourceUpdateScheduler {
    private static final Logger log = LoggerFactory.getLogger(TmsDataSourceUpdateScheduler.class);
    private static final int REMOVE_LIMIT_DAY = 5;

    public void unusedDatasourceChecker() {
        int nowDay = Integer.valueOf(DateUtil.getWorkday());
        try {
            Map<String, Integer> datasourceUsedTime = TmsBatchDataSourceManager.INSTANCE.usedTime();
            for (String key : datasourceUsedTime.keySet()) {
                Integer lastUseDay = datasourceUsedTime.get(key);
                if (nowDay <= lastUseDay + 5) continue;
                TmsBatchDataSourceManager.INSTANCE.removeDataSource(key);
            }
        }
        catch (Exception e) {
            log.error("datasource remove checker error", (Throwable)e);
        }
    }
}

