/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor.feasibility;

import com.google.gson.Gson;
import com.humuson.tms.config.Constants;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.monitor.feasibility.HttpCallParser;
import com.humuson.tms.monitor.feasibility.WatcherInfo;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class WatcherHttpCallParser
implements HttpCallParser {
    private static final Logger log = LoggerFactory.getLogger(WatcherHttpCallParser.class);
    @Autowired
    private TmsCommonConfig tmsConfig;
    private int responseCode;
    private String watchUrl;
    private WatcherInfo watcherInfo = null;

    @Override
    public String getUrl() {
        return this.watchUrl;
    }

    @Override
    public Map<String, String> getInputParameters() {
        return null;
    }

    public WatcherInfo resultParser(String resultParameters) {
        this.watcherInfo = (WatcherInfo)new Gson().fromJson(resultParameters, WatcherInfo.class);
        return this.watcherInfo;
    }

    @Override
    public void setResponseCode(int httpCode) {
        this.responseCode = httpCode;
    }

    @Override
    public boolean isOk() {
        if (ObjectUtils.isEmpty((Object)this.watcherInfo)) {
            return false;
        }
        if (ObjectUtils.isEmpty((Object)this.watcherInfo.getStatus())) {
            return false;
        }
        return this.watcherInfo.getStatus().equalsIgnoreCase("ok");
    }

    public void callWatcher(Constants.JobName jobName) {
        String[] urls;
        for (String url : urls = this.tmsConfig.getWatcherUrls()) {
            try {
                String watchUrl = this.makeWatchUrl(url.trim(), this.tmsConfig.getEngine() + this.tmsConfig.getNode(), jobName);
                this.setWatchUrl(watchUrl);
                this.callUrl();
                break;
            }
            catch (Exception e) {
                log.error("watch process call error. so next..", (Throwable)e);
            }
        }
    }

    private String makeWatchUrl(String url, String daemon, Constants.JobName jobName) {
        return String.valueOf(url) + "?" + "daemon=" + daemon + "&" + "process=" + jobName.name();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void callUrl() {
        block17: {
            BufferedReader in = null;
            HttpURLConnection connection = null;
            try {
                connection = (HttpURLConnection)new URL(this.getUrl()).openConnection();
                connection.setRequestMethod("GET");
                StringBuffer response = new StringBuffer();
                int responseCode = connection.getResponseCode();
                this.setResponseCode(responseCode);
                if (responseCode == 200) {
                    String line;
                    in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                    while ((line = in.readLine()) != null) {
                        response.append(line);
                    }
                    this.resultParser(response.toString().trim());
                    break block17;
                }
                log.error("Http[" + this.getUrl() + "] response Code [" + responseCode + "] so job finish ");
                return;
            }
            catch (Exception e) {
                log.error("failed call http url[{}] Exception {}", (Object)this.getUrl(), (Object)e.getMessage());
            }
            finally {
                if (connection != null) {
                    connection.disconnect();
                    connection = null;
                }
                try {
                    if (in != null) {
                        in.close();
                    }
                }
                catch (Exception e2) {
                    log.error("[se] retry error {}", (Object)this.getUrl(), (Object)e2);
                }
            }
        }
    }

    public static String jsonCallUrl(String url) throws Exception {
        BufferedReader in = null;
        HttpURLConnection connection = null;
        try {
            connection = (HttpURLConnection)new URL(url).openConnection();
            connection.setRequestMethod("GET");
            StringBuffer response = new StringBuffer();
            int responseCode = connection.getResponseCode();
            if (responseCode == 200) {
                String line;
                log.info("Response Code : " + responseCode);
                in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
                while ((line = in.readLine()) != null) {
                    response.append(line);
                }
                String string = response.toString().trim();
                return string;
            }
            String string = "" + responseCode;
            return string;
        }
        catch (Exception e) {
            log.error("failed call http url[{}] Exception ", (Object)url, (Object)e);
            throw e;
        }
        finally {
            if (connection != null) {
                connection.disconnect();
                connection = null;
            }
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception e2) {
                log.error("[se] retry error {}", (Object)url, (Object)e2);
            }
        }
    }

    public static void main(String[] args) {
        WatcherHttpCallParser watcher = new WatcherHttpCallParser();
        watcher.callWatcher(Constants.JobName.MAPPING);
        while (!watcher.isOk()) {
        }
    }

    public TmsCommonConfig getTmsConfig() {
        return this.tmsConfig;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getWatchUrl() {
        return this.watchUrl;
    }

    public WatcherInfo getWatcherInfo() {
        return this.watcherInfo;
    }

    public void setTmsConfig(TmsCommonConfig tmsConfig) {
        this.tmsConfig = tmsConfig;
    }

    public void setWatchUrl(String watchUrl) {
        this.watchUrl = watchUrl;
    }

    public void setWatcherInfo(WatcherInfo watcherInfo) {
        this.watcherInfo = watcherInfo;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof WatcherHttpCallParser)) {
            return false;
        }
        WatcherHttpCallParser other = (WatcherHttpCallParser)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TmsCommonConfig this$tmsConfig = this.getTmsConfig();
        TmsCommonConfig other$tmsConfig = other.getTmsConfig();
        if (this$tmsConfig == null ? other$tmsConfig != null : !((Object)this$tmsConfig).equals(other$tmsConfig)) {
            return false;
        }
        if (this.getResponseCode() != other.getResponseCode()) {
            return false;
        }
        String this$watchUrl = this.getWatchUrl();
        String other$watchUrl = other.getWatchUrl();
        if (this$watchUrl == null ? other$watchUrl != null : !this$watchUrl.equals(other$watchUrl)) {
            return false;
        }
        WatcherInfo this$watcherInfo = this.getWatcherInfo();
        WatcherInfo other$watcherInfo = other.getWatcherInfo();
        return !(this$watcherInfo == null ? other$watcherInfo != null : !((Object)this$watcherInfo).equals(other$watcherInfo));
    }

    protected boolean canEqual(Object other) {
        return other instanceof WatcherHttpCallParser;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TmsCommonConfig $tmsConfig = this.getTmsConfig();
        result = result * 59 + ($tmsConfig == null ? 43 : ((Object)$tmsConfig).hashCode());
        result = result * 59 + this.getResponseCode();
        String $watchUrl = this.getWatchUrl();
        result = result * 59 + ($watchUrl == null ? 43 : $watchUrl.hashCode());
        WatcherInfo $watcherInfo = this.getWatcherInfo();
        result = result * 59 + ($watcherInfo == null ? 43 : ((Object)$watcherInfo).hashCode());
        return result;
    }

    public String toString() {
        return "WatcherHttpCallParser(tmsConfig=" + this.getTmsConfig() + ", responseCode=" + this.getResponseCode() + ", watchUrl=" + this.getWatchUrl() + ", watcherInfo=" + this.getWatcherInfo() + ")";
    }
}

