/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor.feasibility;

import com.humuson.tms.config.Constants;
import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.monitor.feasibility.ProcessFeasible;
import com.humuson.tms.monitor.feasibility.WatcherHttpCallParser;
import java.lang.reflect.Method;
import javax.annotation.PostConstruct;
import jodd.util.StringUtil;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Aspect
@Component
@ConditionalOnProperty(prefix="tms.monitor.watcher", name={"used"}, havingValue="true", matchIfMissing=true)
public class ProcessFeasibleInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ProcessFeasibleInterceptor.class);
    @Autowired
    private TmsCommonConfig tmsConfig;
    private static String DEMON_NAME = "";
    public static final String NO = "NO";
    @Autowired
    WatcherHttpCallParser parser;

    @PostConstruct
    public void init() {
        DEMON_NAME = this.tmsConfig.getEngine() + this.tmsConfig.getNode();
    }

    @Around(value="@annotation(com.humuson.tms.monitor.feasibility.ProcessFeasible)")
    public void around(ProceedingJoinPoint joinPoint) {
        Method method = ((MethodSignature)joinPoint.getSignature()).getMethod();
        if (log.isDebugEnabled()) {
            log.debug("this method[{}] process feasible comfirm..", (Object)method.getName());
        }
        try {
            ProcessFeasible processFeasible = method.getAnnotation(ProcessFeasible.class);
            String demonName = processFeasible.value();
            Constants.JobName jobName = processFeasible.name();
            if (StringUtil.isEmpty((CharSequence)demonName)) {
                demonName = DEMON_NAME;
            }
            this.parser.callWatcher(jobName);
            if (!this.parser.isOk()) {
                log.warn("job={}(method={}) was ordered to skip by the watcher server. so skiped", (Object)jobName.name(), (Object)method.getName());
                return;
            }
            joinPoint.proceed();
        }
        catch (Exception e) {
            log.error("this method[{}] running error", (Object)method.getName(), (Object)e);
        }
        catch (Throwable e) {
            log.error("this method[{}] running error", (Object)method.getName(), (Object)e);
        }
    }
}

