/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor.command;

import com.humuson.tms.monitor.command.AbstractMonitorCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class DelayMonitorCommand
extends AbstractMonitorCommand<Integer> {
    private static final Logger log = LoggerFactory.getLogger(DelayMonitorCommand.class);
    @Value(value="${tms.monitor.delay.time:3}")
    private int level;

    @Override
    public void command() throws Exception {
        try {
            log.info("delay monitor command sleep({})", (Object)(this.level * 1000));
            Thread.sleep(this.level * 1000);
        }
        catch (Exception e) {
            log.error("delay command sleep error", (Throwable)e);
            throw e;
        }
    }

    @Override
    public void regParam(Integer t) {
        this.level = t;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DelayMonitorCommand)) {
            return false;
        }
        DelayMonitorCommand other = (DelayMonitorCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getLevel() == other.getLevel();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DelayMonitorCommand;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        return result;
    }

    @Override
    public String toString() {
        return "DelayMonitorCommand(level=" + this.getLevel() + ")";
    }
}

