/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor.command;

import com.humuson.tms.monitor.AbstractLimitTimer;
import com.humuson.tms.monitor.command.AbstractMonitorCommand;
import com.humuson.tms.repository.model.AlramReceiver;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class AlramMonitorCommand
extends AbstractMonitorCommand<AlramReceiver> {
    private static final Logger log = LoggerFactory.getLogger(AlramMonitorCommand.class);
    @Value(value="${tms.monitor.alram.retry.term-second:60}")
    private int cycle;
    private List<AlramReceiver> receivers = new ArrayList<AlramReceiver>();
    AbstractLimitTimer<List<AlramReceiver>> abtractLimitTimer = new AbstractLimitTimer<List<AlramReceiver>>(){

        @Override
        public void timeOverExecute(List<AlramReceiver> channels) throws Exception {
            for (AlramReceiver channel : channels) {
                AlramMonitorCommand.this.alram(channel);
            }
        }

        @Override
        protected int limitSecTime() {
            return AlramMonitorCommand.this.cycle;
        }
    };

    public void clear() {
        this.receivers.clear();
    }

    @Override
    public void command() throws Exception {
        this.abtractLimitTimer.timeOverExecute(this.receivers);
    }

    private void alram(AlramReceiver receiver) {
        try {
            log.warn("this channel[{}] alram addition infomation[{}] ", (Object)receiver, this.receivers);
        }
        catch (Exception e) {
            log.error("channel[{}] alram error ", (Object)receiver, (Object)e);
        }
    }

    @Override
    public void regParam(AlramReceiver t) {
        this.receivers.add(t);
    }
}

