/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor;

import com.humuson.tms.monitor.PredictThresholdTimer;
import com.humuson.tms.monitor.ProgressStatusEventer;
import com.humuson.tms.monitor.ProgressStatusInfo;
import com.humuson.tms.util.CheckerPossibleOfChain;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.lang.management.MemoryUsage;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class TmsMemoryMonitorNotification2
extends CheckerPossibleOfChain<ProgressStatusEventer> {
    private static final Logger log = LoggerFactory.getLogger(TmsMemoryMonitorNotification2.class);
    private static String NO_MESSAGE = "heap memory limit over";
    @Value(value="${tms.monitor.memory.heap.limit-per:10}")
    private int heapLimit;
    @Value(value="${tms.monitor.memory.heap.term-second:10}")
    private int heapMemoryTermSecond;
    @Value(value="${tms.monitor.memory.non-heap.limit-per:80}")
    private int nonHeapLimit;
    @Value(value="${tms.monitor.memory.non-heap.term-second:10}")
    private int nonHeapMemoryTermSecond;
    @Autowired
    PredictThresholdTimer predictThresholdTimer;

    @Override
    protected boolean isSuccess(ProgressStatusEventer eventer) {
        boolean isDangerous;
        MemoryUsage heapMemory = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
        MemoryUsage nonHeapMemory = ManagementFactory.getMemoryMXBean().getNonHeapMemoryUsage();
        double nowHeapMemoryMB = this.nowUseMemory(heapMemory);
        double nowNonHeapMemoryMB = this.nowUseMemory(nonHeapMemory);
        if (log.isInfoEnabled()) {
            log.info("now heap memory[{}MB]/max[{}MB] , now non heap memory[{}MB]/limit[{}MB]", new Object[]{nowHeapMemoryMB, heapMemory.getMax() / 0x100000L, nowNonHeapMemoryMB, nonHeapMemory.getMax() / 0x100000L});
        }
        if (nowHeapMemoryMB > (double)this.heapLimit && (isDangerous = this.continueDangerousCondition(this.heapMemoryTermSecond, heapMemory, nowHeapMemoryMB))) {
            double errPredictSecond = this.predictThresholdTimer.predictOccurred(heapMemory.getMax(), TimeUnit.SECONDS);
            NO_MESSAGE = "The threshold is expected to be reached in " + errPredictSecond + " seconds.this system heap memory limit over set[" + this.heapLimit + "%] now[" + nowHeapMemoryMB + "]";
            ProgressStatusInfo status = eventer.progressStatusInfo();
            status.setDate(new Date());
            status.setEvent(ProgressStatusInfo.MonitorEvent.HEAP_MEMORY);
            status.setMenu("heapMemory");
            status.setPredictThresholdTime(errPredictSecond);
            status.setUsed((long)nowHeapMemoryMB);
            status.setMax(heapMemory.getMax());
            return false;
        }
        if (nowNonHeapMemoryMB > (double)this.nonHeapLimit && (isDangerous = this.continueDangerousCondition(this.nonHeapMemoryTermSecond, nonHeapMemory, nowNonHeapMemoryMB))) {
            double errPredictSecond = this.predictThresholdTimer.predictOccurred(nonHeapMemory.getMax(), TimeUnit.SECONDS);
            NO_MESSAGE = "The threshold is expected to be reached in " + errPredictSecond + " seconds.this system memory limit over set[" + this.nonHeapLimit + "] now[" + nowNonHeapMemoryMB + "]";
            ProgressStatusInfo status = eventer.progressStatusInfo();
            status.setDate(new Date());
            status.setEvent(ProgressStatusInfo.MonitorEvent.SYSTEM_MEMORY);
            status.setMenu("nonHeapMemory");
            status.setPredictThresholdTime(errPredictSecond);
            status.setUsed((long)nowNonHeapMemoryMB);
            status.setMax(nonHeapMemory.getMax());
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("system Memory status good heap[{}] non-heap", (Object)nowHeapMemoryMB, (Object)nowNonHeapMemoryMB);
        }
        return true;
    }

    private boolean continueDangerousCondition(int limit, MemoryUsage heapMemory, double nowHeapMemoryMB) {
        for (int i = 0; i < limit; ++i) {
            try {
                Thread.sleep(1000L);
                nowHeapMemoryMB = this.nowUseMemory(heapMemory);
                if (!(nowHeapMemoryMB > (double)this.heapLimit)) {
                    this.predictThresholdTimer.clear();
                    return false;
                }
                this.predictThresholdTimer.put(i, nowHeapMemoryMB);
                continue;
            }
            catch (Exception e) {
                log.error("heap memory monitor error ", (Throwable)e);
            }
        }
        return true;
    }

    private long nowUseMemory(MemoryUsage heapMemory) {
        return heapMemory.getUsed() / 0x100000L / (heapMemory.getMax() / 0x100000L) * 100L;
    }

    public static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new IllegalStateException("Could not find tenured space");
    }

    @Override
    protected String getImpassableMessage() {
        return NO_MESSAGE;
    }
}

