/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor;

import com.humuson.tms.monitor.PredictThresholdTimer;
import com.humuson.tms.monitor.ProgressStatusEventer;
import com.humuson.tms.monitor.ProgressStatusInfo;
import com.humuson.tms.util.CheckerPossibleOfChain;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class TmsMemoryMonitorNotification
extends CheckerPossibleOfChain<ProgressStatusEventer> {
    private static final Logger log = LoggerFactory.getLogger(TmsMemoryMonitorNotification.class);
    private static String NO_MESSAGE = "heap memory limit over";
    @Value(value="${tms.monitor.memory.heap.limit-per:10}")
    private int heapLimit;
    @Value(value="${tms.monitor.memory.heap.term-second:10}")
    private int heapMemoryTermSecond;
    @Value(value="${tms.monitor.memory.non-heap.limit-per:80}")
    private int nonHeapLimit;
    @Value(value="${tms.monitor.memory.non-heap.term-second:10}")
    private int nonHeapMemoryTermSecond;
    @Autowired
    PredictThresholdTimer predictThresholdTimer;

    @Override
    protected boolean isSuccess(ProgressStatusEventer eventer) {
        boolean isDangerous;
        long freeSizeMB = Runtime.getRuntime().freeMemory() / 0x100000L;
        long totalSizeMB = Runtime.getRuntime().totalMemory() / 0x100000L;
        long useHeapSizeMB = totalSizeMB - freeSizeMB;
        int usePercent = (int)(useHeapSizeMB * 100L / totalSizeMB);
        if (log.isInfoEnabled()) {
            log.info("now heap memory[{}MB]/max[{}MB] use percent[{}]", new Object[]{useHeapSizeMB, totalSizeMB, usePercent});
        }
        if (usePercent > this.heapLimit && (isDangerous = this.continueDangerousCondition(this.heapMemoryTermSecond))) {
            double errPredictSecond = this.predictThresholdTimer.predictOccurred(totalSizeMB, TimeUnit.SECONDS);
            NO_MESSAGE = "The threshold is expected to be reached in " + errPredictSecond + " seconds.this system heap memory limit over set[" + this.heapLimit + "%] now[" + useHeapSizeMB + "]";
            ProgressStatusInfo status = eventer.progressStatusInfo();
            status.setDate(new Date());
            status.setEvent(ProgressStatusInfo.MonitorEvent.HEAP_MEMORY);
            status.setMenu("heapMemory");
            status.setPredictThresholdTime(errPredictSecond);
            status.setUsed(useHeapSizeMB);
            status.setMax(totalSizeMB);
            return false;
        }
        return true;
    }

    private boolean continueDangerousCondition(int limit) {
        for (int i = 0; i < limit; ++i) {
            try {
                Thread.sleep(1000L);
                long freeSizeMB = Runtime.getRuntime().freeMemory() / 0x100000L;
                long totalSizeMB = Runtime.getRuntime().totalMemory() / 0x100000L;
                double useHeapSizeMB = totalSizeMB - freeSizeMB;
                int usePercent = (int)(useHeapSizeMB * 100.0 / (double)totalSizeMB);
                if (usePercent <= this.heapLimit) {
                    this.predictThresholdTimer.clear();
                    return false;
                }
                this.predictThresholdTimer.put(i, useHeapSizeMB);
                continue;
            }
            catch (Exception e) {
                log.error("heap memory monitor error ", (Throwable)e);
            }
        }
        return true;
    }

    public static MemoryPoolMXBean findTenuredGenPool() {
        for (MemoryPoolMXBean pool : ManagementFactory.getMemoryPoolMXBeans()) {
            if (pool.getType() != MemoryType.HEAP || !pool.isUsageThresholdSupported()) continue;
            return pool;
        }
        throw new IllegalStateException("Could not find tenured space");
    }

    @Override
    protected String getImpassableMessage() {
        return NO_MESSAGE;
    }
}

