/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor;

import com.humuson.tms.config.TmsCommonConfig;
import com.humuson.tms.monitor.EngineMonitorBroker;
import com.humuson.tms.monitor.NotificationContext;
import com.humuson.tms.monitor.command.MonitorCommand;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TmsEngineMonitorBroker
implements EngineMonitorBroker<MonitorCommand> {
    private static final Logger log = LoggerFactory.getLogger(TmsEngineMonitorBroker.class);
    @Autowired
    private TmsCommonConfig config;

    @Override
    public String engineName() {
        return this.config.getEngine() + this.config.getNode();
    }

    @Override
    public void commandOrder(MonitorCommand command) {
        for (NotificationContext notification : NotificationContext.values()) {
            String notifyName = notification.name();
            if (notifyName.indexOf(this.config.getEngine()) < 0 || notifyName.indexOf("Observer") <= 0) continue;
            log.warn("receive and notify command[{}] from manager. engine[{}]", (Object)command.getClass().getName(), (Object)this.engineName());
            notification.notifyStatus(command);
        }
    }
}

