/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor;

import com.humuson.tms.monitor.PredictThresholdTimer;
import com.humuson.tms.monitor.ProgressStatusEventer;
import com.humuson.tms.monitor.ProgressStatusInfo;
import com.humuson.tms.util.CheckerPossibleOfChain;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class TmsCpuMonitorNotification
extends CheckerPossibleOfChain<ProgressStatusEventer> {
    private static final Logger log = LoggerFactory.getLogger(TmsCpuMonitorNotification.class);
    private OperatingSystemMXBean osBean;
    @Value(value="${tms.monitor.cpu.system.limit-per:80}")
    private int cpuSystemLimit;
    @Value(value="${tms.monitor.cpu.system.term-second:10}")
    private int cpuTermSecond;
    @Autowired
    PredictThresholdTimer predictThresholdTimer;
    private String message = "cpu monitor";

    @PostConstruct
    public void init() {
        this.osBean = (OperatingSystemMXBean)ManagementFactory.getPlatformMXBean(java.lang.management.OperatingSystemMXBean.class);
    }

    @Override
    protected boolean isSuccess(ProgressStatusEventer event) {
        double nowSystem = this.nowSystemCPUStatus();
        if (log.isInfoEnabled()) {
            log.info("now CPU status [{}]/limit per[{}]", (Object)nowSystem, (Object)this.cpuSystemLimit);
        }
        if (this.isOverLimit(nowSystem)) {
            for (int i = 0; i < this.cpuTermSecond; ++i) {
                try {
                    Thread.sleep(1000L);
                    nowSystem = this.nowSystemCPUStatus();
                    if (!this.isOverLimit(nowSystem)) {
                        this.predictThresholdTimer.clear();
                        return true;
                    }
                    this.predictThresholdTimer.put(i, nowSystem);
                    continue;
                }
                catch (Exception e) {
                    log.error("system CPU monitor error ", (Throwable)e);
                }
            }
            double errPredictSecond = this.predictThresholdTimer.predictOccurred(100.0, TimeUnit.SECONDS);
            this.message = "The threshold is expected to be reached in " + errPredictSecond + " seconds.this system CPU limit(" + this.cpuSystemLimit + ") over now utilization=" + nowSystem;
            log.warn(this.message);
            log.warn("this system CPU[{}] base value[{}] / engine process CPU[{}]", new Object[]{nowSystem, this.cpuSystemLimit, this.osBean.getProcessCpuLoad() * 100.0});
            ProgressStatusInfo status = event.progressStatusInfo();
            status.setDate(new Date());
            status.setPredictThresholdTime(errPredictSecond);
            status.setUsed((long)nowSystem);
            status.setEvent(ProgressStatusInfo.MonitorEvent.CPU);
            status.setMax(this.cpuSystemLimit);
            return false;
        }
        if (log.isDebugEnabled()) {
            log.debug("system CPU status good [{}] ", (Object)nowSystem);
        }
        return true;
    }

    private boolean isOverLimit(double nowSystem) {
        return nowSystem >= (double)this.cpuSystemLimit;
    }

    private double nowSystemCPUStatus() {
        return Double.parseDouble(String.format("%.2f", this.osBean.getSystemCpuLoad() * 100.0));
    }

    @Override
    protected String getImpassableMessage() {
        return this.message;
    }
}

