/*
 * Decompiled with CFR 0.152.
 */
package com.humuson.tms.monitor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.springframework.util.ObjectUtils;

public class PredictThresholdTimer {
    Map<Integer, Double> dataForPredict = new HashMap<Integer, Double>();

    public void put(Integer i, Double d) {
        this.dataForPredict.put(i, d);
    }

    public void clear() {
        this.dataForPredict.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double predictOccurred(double maxValue, TimeUnit unit) {
        if (ObjectUtils.isEmpty(this.dataForPredict)) {
            return 0.0;
        }
        try {
            double Xmean = this.getXMean(this.dataForPredict);
            double Ymean = this.getYMean(this.dataForPredict);
            double inclination = this.getInclination(Xmean, Ymean, this.dataForPredict);
            double bias = Ymean - Xmean * inclination;
            double sec = (maxValue - bias) / inclination;
            if (TimeUnit.SECONDS == unit) {
                double d = sec;
                return d;
            }
            if (TimeUnit.MINUTES == unit) {
                double d = sec % 3600.0 / 60.0;
                return d;
            }
            if (TimeUnit.HOURS == unit) {
                double d = sec / 3600.0;
                return d;
            }
            double d = sec;
            return d;
        }
        finally {
            this.clear();
        }
    }

    private double getInclination(double xmean, double ymean, Map<Integer, Double> dataForPredict) {
        Iterator<Integer> iter = dataForPredict.keySet().iterator();
        double divisor = 0.0;
        double dividend = 0.0;
        while (iter.hasNext()) {
            int key = iter.next();
            double xtmp = (double)key - xmean;
            double ytmp = dataForPredict.get(key) - ymean;
            dividend += xtmp * ytmp;
            divisor += Math.pow(xtmp, 2.0);
        }
        return dividend / divisor;
    }

    private double getXMean(Map<Integer, Double> dataForPredict) {
        Iterator<Integer> iter = dataForPredict.keySet().iterator();
        int number = 0;
        int total = 0;
        while (iter.hasNext()) {
            total += iter.next().intValue();
            ++number;
        }
        return total / number;
    }

    private double getYMean(Map<Integer, Double> dataForPredict) {
        Iterator<Integer> iter = dataForPredict.keySet().iterator();
        int number = 0;
        double total = 0.0;
        while (iter.hasNext()) {
            total += dataForPredict.get(iter.next()).doubleValue();
            ++number;
        }
        return total / (double)number;
    }

    public static void main(String[] args) {
        PredictThresholdTimer threshold = new PredictThresholdTimer();
        for (int i = 0; i < 257; ++i) {
            System.out.println(i + "\ucd08\uc758 \uc0c1\uc2b9 \uac12=" + (i + i));
            threshold.put(i, (double)i + (double)i);
        }
        System.out.println("\uc0c1\uc2b9\uac12 500 \uc758 \uc608\uc0c1 \uc2dc\uac04=" + threshold.predictOccurred(500.0, TimeUnit.SECONDS) + "\ucd08");
    }
}

